/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.application.helper.cli;

import be.yildizgames.common.application.helper.cli.BannerLine;
import be.yildizgames.common.application.helper.cli.Terminal;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class Banner {
    private static final int LINE_LENGTH = 80;
    private static final String BORDER_LINE = "*".repeat(80);
    private static final String SIDE_LINE = "*" + " ".repeat(78) + "*";
    private final String appName;
    private final List<String> lines = new ArrayList<String>();
    private final List<BannerLine> addedLines = new ArrayList<BannerLine>();

    public Banner(String appName) {
        this.appName = appName;
        this.addLines();
    }

    public void addLine(BannerLine line) {
        this.addedLines.add(line);
    }

    public void fromFile(Path path) {
        this.lines.clear();
        try (Stream<String> content = Files.lines(path);){
            content.forEach(this.lines::add);
        }
        catch (IOException e) {
            Terminal.println(e.toString());
            this.addLines();
            this.lines.add("*-- ERROR reading file: " + path);
        }
    }

    private void addLines() {
        this.lines.add(BORDER_LINE);
        this.lines.add(SIDE_LINE);
        int start = 78 - this.appName.length() >> 1;
        this.lines.add("*" + " ".repeat(start) + this.appName + " ".repeat(start) + "*");
        this.lines.add(SIDE_LINE);
        String s = "*   Powered by Yildiz-Engine";
        this.lines.add(s + " ".repeat(80 - s.length() - 1) + "*");
        String e = "https://engine.yildiz-games.be   *";
        this.lines.add("*" + " ".repeat(80 - e.length() - 1) + e);
    }

    public void display() {
        this.lines.forEach(Terminal::println);
        this.addedLines.forEach(l -> Terminal.println(l.print()));
        Terminal.println(SIDE_LINE);
        Terminal.println(BORDER_LINE);
    }
}

