/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.wallet.ApplePaySessionRequest;
import be.woutschoovaerts.mollie.data.wallet.ApplePaySessionResponse;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(WalletHandler.class);
    private static final String WALLETS_APPLEPAY_SESSIONS_URI = "/wallets/applepay/sessions";

    public WalletHandler(String baseApiUrl, Config config) {
        super(baseApiUrl, log, config);
    }

    public ApplePaySessionResponse requestApplePaySession(ApplePaySessionRequest body) throws MollieException {
        try {
            HttpResponse<String> response = this.post(WALLETS_APPLEPAY_SESSIONS_URI, body);
            return (ApplePaySessionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), ApplePaySessionResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

