/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.common.Pagination;
import be.woutschoovaerts.mollie.data.payment.PaymentListResponse;
import be.woutschoovaerts.mollie.data.subscription.SubscriptionListResponse;
import be.woutschoovaerts.mollie.data.subscription.SubscriptionRequest;
import be.woutschoovaerts.mollie.data.subscription.SubscriptionResponse;
import be.woutschoovaerts.mollie.data.subscription.UpdateSubscriptionRequest;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionHandler.class);

    public SubscriptionHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public SubscriptionResponse createSubscription(String customerId, SubscriptionRequest body) throws MollieException {
        return this.createSubscription(customerId, body, new QueryParams());
    }

    public SubscriptionResponse createSubscription(String customerId, SubscriptionRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/subscriptions";
            HttpResponse<String> response = this.post(uri, body, params);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public SubscriptionResponse getSubscription(String customerId, String subscriptionId) throws MollieException {
        return this.getSubscription(customerId, subscriptionId, new QueryParams());
    }

    public SubscriptionResponse getSubscription(String customerId, String subscriptionId, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/subscriptions/" + subscriptionId;
            HttpResponse<String> response = this.get(uri, params, true);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public SubscriptionResponse cancelSubscription(String customerId, String subscriptionId) throws MollieException {
        return this.cancelSubscription(customerId, subscriptionId, new QueryParams());
    }

    public SubscriptionResponse cancelSubscription(String customerId, String subscriptionId, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/subscriptions/" + subscriptionId;
            HttpResponse<String> response = this.delete(uri, params, true);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<SubscriptionListResponse> listSubscriptions(String customerId) throws MollieException {
        return this.listSubscriptions(customerId, new QueryParams());
    }

    public Pagination<SubscriptionListResponse> listSubscriptions(String customerId, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/subscriptions";
            HttpResponse<String> response = this.get(uri, params, true);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<SubscriptionListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<PaymentListResponse> listSubscriptionPayments(String customerId, String subscriptionId) throws MollieException {
        return this.listSubscriptionPayments(customerId, subscriptionId, new QueryParams());
    }

    public Pagination<PaymentListResponse> listSubscriptionPayments(String customerId, String subscriptionId, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/subscriptions/" + subscriptionId + "/payments";
            HttpResponse<String> response = this.get(uri, params, true);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PaymentListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public SubscriptionResponse updateSubscription(String customerId, String subscriptionId, UpdateSubscriptionRequest body) throws MollieException {
        return this.updateSubscription(customerId, subscriptionId, body, new QueryParams());
    }

    public SubscriptionResponse updateSubscription(String customerId, String subscriptionId, UpdateSubscriptionRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/subscriptions/" + subscriptionId;
            HttpResponse<String> response = this.patch(uri, body, params);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

