/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.common.Pagination;
import be.woutschoovaerts.mollie.data.shipment.ShipmentListResponse;
import be.woutschoovaerts.mollie.data.shipment.ShipmentRequest;
import be.woutschoovaerts.mollie.data.shipment.ShipmentResponse;
import be.woutschoovaerts.mollie.data.shipment.ShipmentUpdateRequest;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShipmentHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ShipmentHandler.class);

    public ShipmentHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public ShipmentResponse createShipment(String orderId, ShipmentRequest body) throws MollieException {
        return this.createShipment(orderId, body, new QueryParams());
    }

    public ShipmentResponse createShipment(String orderId, ShipmentRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/shipments";
            HttpResponse<String> response = this.post(uri, body, params);
            return (ShipmentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), ShipmentResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public ShipmentResponse getShipment(String orderId, String shipmentId) throws MollieException {
        return this.getShipment(orderId, shipmentId, new QueryParams());
    }

    public ShipmentResponse getShipment(String orderId, String shipmentId, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/shipments/" + shipmentId;
            HttpResponse<String> response = this.get(uri, params, true);
            return (ShipmentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), ShipmentResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<ShipmentListResponse> getShipments(String orderId) throws MollieException {
        return this.getShipments(orderId, new QueryParams());
    }

    public Pagination<ShipmentListResponse> getShipments(String orderId, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/shipments";
            HttpResponse<String> response = this.get(uri, params, true);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<ShipmentListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public ShipmentResponse updateShipment(String orderId, String shipmentId, ShipmentUpdateRequest body) throws MollieException {
        return this.updateShipment(orderId, shipmentId, body, new QueryParams());
    }

    public ShipmentResponse updateShipment(String orderId, String shipmentId, ShipmentUpdateRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/shipments/" + shipmentId;
            HttpResponse<String> response = this.patch(uri, body, params);
            return (ShipmentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), ShipmentResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

