/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.capture.CaptureListResponse;
import be.woutschoovaerts.mollie.data.chargeback.ChargebackListResponse;
import be.woutschoovaerts.mollie.data.common.Pagination;
import be.woutschoovaerts.mollie.data.payment.PaymentListResponse;
import be.woutschoovaerts.mollie.data.refund.RefundListResponse;
import be.woutschoovaerts.mollie.data.settlement.SettlementListResponse;
import be.woutschoovaerts.mollie.data.settlement.SettlementResponse;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettlementHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(SettlementHandler.class);

    public SettlementHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public SettlementResponse getSettlement(String id) throws MollieException {
        return this.getSettlement(id, new QueryParams());
    }

    public SettlementResponse getSettlement(String id, QueryParams params) throws MollieException {
        try {
            String uri = "/settlements/" + id;
            HttpResponse<String> response = this.get(uri, params, false);
            return (SettlementResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SettlementResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<SettlementListResponse> getSettlements() throws MollieException {
        return this.getSettlements(new QueryParams());
    }

    public Pagination<SettlementListResponse> getSettlements(QueryParams params) throws MollieException {
        try {
            String uri = "/settlements";
            HttpResponse<String> response = this.get(uri, params, false);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<SettlementListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public SettlementResponse getNextSettlement() throws MollieException {
        return this.getNextSettlement(new QueryParams());
    }

    public SettlementResponse getNextSettlement(QueryParams params) throws MollieException {
        try {
            String uri = "/settlements/next";
            HttpResponse<String> response = this.get(uri, params, false);
            return (SettlementResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SettlementResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public SettlementResponse getOpenSettlement() throws MollieException {
        return this.getOpenSettlement(new QueryParams());
    }

    public SettlementResponse getOpenSettlement(QueryParams params) throws MollieException {
        try {
            String uri = "/settlements/open";
            HttpResponse<String> response = this.get(uri, params, false);
            return (SettlementResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SettlementResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<PaymentListResponse> getSettlementPayments(String settlementId) throws MollieException {
        return this.getSettlementPayments(settlementId, new QueryParams());
    }

    public Pagination<PaymentListResponse> getSettlementPayments(String settlementId, QueryParams params) throws MollieException {
        try {
            String uri = "/settlements/" + settlementId + "/payments";
            HttpResponse<String> response = this.get(uri, params, false);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PaymentListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<RefundListResponse> getSettlementRefund(String settlementId) throws MollieException {
        return this.getSettlementRefund(settlementId, new QueryParams());
    }

    public Pagination<RefundListResponse> getSettlementRefund(String settlementId, QueryParams params) throws MollieException {
        try {
            String uri = "/settlements/" + settlementId + "/refunds";
            HttpResponse<String> response = this.get(uri, params, false);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<RefundListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<ChargebackListResponse> getSettlementChargebacks(String settlementId) throws MollieException {
        return this.getSettlementChargebacks(settlementId, new QueryParams());
    }

    public Pagination<ChargebackListResponse> getSettlementChargebacks(String settlementId, QueryParams params) throws MollieException {
        try {
            String uri = "/settlements/" + settlementId + "/chargebacks";
            HttpResponse<String> response = this.get(uri, params, false);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<ChargebackListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<CaptureListResponse> getSettlementCaptures(String settlementId) throws MollieException {
        return this.getSettlementCaptures(settlementId, new QueryParams());
    }

    public Pagination<CaptureListResponse> getSettlementCaptures(String settlementId, QueryParams params) throws MollieException {
        try {
            String uri = "/settlements/" + settlementId + "/captures";
            HttpResponse<String> response = this.get(uri, params, false);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<CaptureListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

