/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.common.Pagination;
import be.woutschoovaerts.mollie.data.refund.RefundListResponse;
import be.woutschoovaerts.mollie.data.refund.RefundRequest;
import be.woutschoovaerts.mollie.data.refund.RefundResponse;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefundHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(RefundHandler.class);

    public RefundHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public RefundResponse createRefund(String paymentId, RefundRequest body) throws MollieException {
        return this.createRefund(paymentId, body, new QueryParams());
    }

    public RefundResponse createRefund(String paymentId, RefundRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/payments/" + paymentId + "/refunds";
            HttpResponse<String> response = this.post(uri, body, params);
            return (RefundResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), RefundResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public RefundResponse getRefund(String paymentId, String refundId) throws MollieException {
        return this.getRefund(paymentId, refundId, new QueryParams());
    }

    public RefundResponse getRefund(String paymentId, String refundId, QueryParams params) throws MollieException {
        try {
            String uri = "/payments/" + paymentId + "/refunds/" + refundId;
            HttpResponse<String> response = this.get(uri, params, true);
            return (RefundResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), RefundResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void cancelRefund(String paymentId, String refundId) throws MollieException {
        this.cancelRefund(paymentId, refundId, new QueryParams());
    }

    public void cancelRefund(String paymentId, String refundId, QueryParams params) throws MollieException {
        try {
            String uri = "/payments/" + paymentId + "/refunds/" + refundId;
            HttpResponse<String> httpResponse = this.delete(uri, params, true);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<RefundListResponse> listRefunds() throws MollieException {
        return this.listRefunds(new QueryParams());
    }

    public Pagination<RefundListResponse> listRefunds(QueryParams params) throws MollieException {
        try {
            String uri = "/refunds";
            HttpResponse<String> response = this.get(uri, params, true);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<RefundListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<RefundListResponse> listRefunds(String paymentId) throws MollieException {
        return this.listRefunds(paymentId, new QueryParams());
    }

    public Pagination<RefundListResponse> listRefunds(String paymentId, QueryParams params) throws MollieException {
        try {
            String uri = "/payments/" + paymentId + "/refunds";
            HttpResponse<String> response = this.get(uri, params, true);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<RefundListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

