/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.common.Pagination;
import be.woutschoovaerts.mollie.data.permission.Permission;
import be.woutschoovaerts.mollie.data.permission.PermissionListResponse;
import be.woutschoovaerts.mollie.data.permission.PermissionResponse;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(PermissionHandler.class);

    public PermissionHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public PermissionResponse getPermission(Permission permission) throws MollieException {
        return this.getPermission(permission, new QueryParams());
    }

    public PermissionResponse getPermission(Permission permission, QueryParams params) throws MollieException {
        try {
            String uri = "/permissions/" + permission.getValue();
            HttpResponse<String> response = this.get(uri, params, false);
            return (PermissionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PermissionResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<PermissionListResponse> getPermissions() throws MollieException {
        return this.getPermissions(new QueryParams());
    }

    public Pagination<PermissionListResponse> getPermissions(QueryParams params) throws MollieException {
        try {
            String uri = "/permissions";
            HttpResponse<String> response = this.get(uri, params, false);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PermissionListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

