/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.common.Pagination;
import be.woutschoovaerts.mollie.data.payment.PaymentListResponse;
import be.woutschoovaerts.mollie.data.payment.PaymentRequest;
import be.woutschoovaerts.mollie.data.payment.PaymentResponse;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(PaymentHandler.class);

    public PaymentHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public PaymentResponse createPayment(PaymentRequest body) throws MollieException {
        return this.createPayment(body, new QueryParams());
    }

    public PaymentResponse createPayment(PaymentRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/payments";
            HttpResponse<String> response = this.post(uri, body, params);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public PaymentResponse getPayment(String paymentId) throws MollieException {
        return this.getPayment(paymentId, new QueryParams());
    }

    public PaymentResponse getPayment(String paymentId, QueryParams params) throws MollieException {
        try {
            String uri = "/payments/" + paymentId;
            HttpResponse<String> response = this.get(uri, params, true);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public PaymentResponse cancelPayment(String paymentId) throws MollieException {
        return this.cancelPayment(paymentId, new QueryParams());
    }

    public PaymentResponse cancelPayment(String paymentId, QueryParams params) throws MollieException {
        try {
            String uri = "/payments/" + paymentId;
            HttpResponse<String> response = this.delete(uri, params, true);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<PaymentListResponse> listPayments() throws MollieException {
        return this.listPayments(new QueryParams());
    }

    public Pagination<PaymentListResponse> listPayments(QueryParams params) throws MollieException {
        try {
            String uri = "/payments";
            HttpResponse<String> response = this.get(uri, params, true);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PaymentListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

