/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.common.Pagination;
import be.woutschoovaerts.mollie.data.order.CancelOrderLinesRequest;
import be.woutschoovaerts.mollie.data.order.OrderLineUpdateRequest;
import be.woutschoovaerts.mollie.data.order.OrderListResponse;
import be.woutschoovaerts.mollie.data.order.OrderPaymentRequest;
import be.woutschoovaerts.mollie.data.order.OrderRefundListResponse;
import be.woutschoovaerts.mollie.data.order.OrderRefundRequest;
import be.woutschoovaerts.mollie.data.order.OrderRequest;
import be.woutschoovaerts.mollie.data.order.OrderResponse;
import be.woutschoovaerts.mollie.data.order.OrderUpdateRequest;
import be.woutschoovaerts.mollie.data.payment.PaymentResponse;
import be.woutschoovaerts.mollie.data.refund.RefundResponse;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(OrderHandler.class);

    public OrderHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public OrderResponse createOrder(OrderRequest body) throws MollieException {
        return this.createOrder(body, new QueryParams());
    }

    public OrderResponse createOrder(OrderRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders";
            HttpResponse<String> response = this.post(uri, body, params);
            return (OrderResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrderResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public OrderResponse getOrder(String orderId) throws MollieException {
        return this.getOrder(orderId, new QueryParams());
    }

    public OrderResponse getOrder(String orderId, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId;
            HttpResponse<String> response = this.get(uri, params, true);
            return (OrderResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrderResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<OrderListResponse> getOrders() throws MollieException {
        return this.getOrders(new QueryParams());
    }

    public Pagination<OrderListResponse> getOrders(QueryParams params) throws MollieException {
        try {
            String uri = "/orders";
            HttpResponse<String> response = this.get(uri, params, true);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<OrderListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public OrderResponse updateOrder(String orderId, OrderUpdateRequest body) throws MollieException {
        return this.updateOrder(orderId, body, new QueryParams());
    }

    public OrderResponse updateOrder(String orderId, OrderUpdateRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId;
            HttpResponse<String> response = this.patch(uri, body, params);
            return (OrderResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrderResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public OrderResponse updateOrderLine(String orderId, String lineId, OrderLineUpdateRequest body) throws MollieException {
        return this.updateOrderLine(orderId, lineId, body, new QueryParams());
    }

    public OrderResponse updateOrderLine(String orderId, String lineId, OrderLineUpdateRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/lines/" + lineId;
            HttpResponse<String> response = this.patch(uri, body, params);
            return (OrderResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrderResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public OrderResponse cancelOrder(String orderId) throws MollieException {
        return this.cancelOrder(orderId, new QueryParams());
    }

    public OrderResponse cancelOrder(String orderId, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId;
            HttpResponse<String> response = this.delete(uri, params, true);
            return (OrderResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrderResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void cancelOrderLines(String orderId, CancelOrderLinesRequest body) throws MollieException {
        this.cancelOrderLines(orderId, body, new QueryParams());
    }

    public void cancelOrderLines(String orderId, CancelOrderLinesRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/lines";
            this.delete(uri, body, params);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public PaymentResponse createOrderPayment(String orderId, OrderPaymentRequest body) throws MollieException {
        return this.createOrderPayment(orderId, body, new QueryParams());
    }

    public PaymentResponse createOrderPayment(String orderId, OrderPaymentRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/payments";
            HttpResponse<String> response = this.post(uri, body, params);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public RefundResponse createOrderRefund(String orderId, OrderRefundRequest body) throws MollieException {
        return this.createOrderRefund(orderId, body, new QueryParams());
    }

    public RefundResponse createOrderRefund(String orderId, OrderRefundRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/refunds";
            HttpResponse<String> response = this.post(uri, body, params);
            return (RefundResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), RefundResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<OrderRefundListResponse> getOrderRefunds(String orderId) throws MollieException {
        return this.getOrderRefunds(orderId, new QueryParams());
    }

    public Pagination<OrderRefundListResponse> getOrderRefunds(String orderId, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/refunds";
            HttpResponse<String> response = this.get(uri, params);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<OrderRefundListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

