/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.common.Pagination;
import be.woutschoovaerts.mollie.data.method.MethodListResponse;
import be.woutschoovaerts.mollie.data.method.MethodResponse;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandler.class);

    public MethodHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public Pagination<MethodListResponse> listMethods() throws MollieException {
        return this.listMethods(new QueryParams());
    }

    public Pagination<MethodListResponse> listMethods(QueryParams params) throws MollieException {
        try {
            String uri = "/methods";
            HttpResponse<String> response = this.get(uri, params, true);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<MethodListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<MethodListResponse> listAllMethods() throws MollieException {
        return this.listAllMethods(new QueryParams());
    }

    public Pagination<MethodListResponse> listAllMethods(QueryParams params) throws MollieException {
        try {
            String uri = "/methods/all";
            HttpResponse<String> response = this.get(uri, params, false);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<MethodListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public MethodResponse getMethod(String methodId) throws MollieException {
        return this.getMethod(methodId, new QueryParams());
    }

    public MethodResponse getMethod(String methodId, QueryParams params) throws MollieException {
        try {
            String uri = "/methods/" + methodId;
            HttpResponse<String> response = this.get(uri, params, true);
            return (MethodResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<MethodResponse>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

