/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.common.Pagination;
import be.woutschoovaerts.mollie.data.mandate.MandateListResponse;
import be.woutschoovaerts.mollie.data.mandate.MandateRequest;
import be.woutschoovaerts.mollie.data.mandate.MandateResponse;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MandateHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(MandateHandler.class);

    public MandateHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public MandateResponse createMandate(String customerId, MandateRequest body) throws MollieException {
        return this.createMandate(customerId, body, new QueryParams());
    }

    public MandateResponse createMandate(String customerId, MandateRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/mandates";
            HttpResponse<String> response = this.post(uri, body, params);
            return (MandateResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), MandateResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public MandateResponse getMandate(String customerId, String mandateId) throws MollieException {
        return this.getMandate(customerId, mandateId, new QueryParams());
    }

    public MandateResponse getMandate(String customerId, String mandateId, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/mandates/" + mandateId;
            HttpResponse<String> response = this.get(uri, params, true);
            return (MandateResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), MandateResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void revokeMandate(String customerId, String mandateId) throws MollieException {
        this.revokeMandate(customerId, mandateId, new QueryParams());
    }

    public void revokeMandate(String customerId, String mandateId, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/mandates/" + mandateId;
            HttpResponse<String> httpResponse = this.delete(uri, params, true);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<MandateListResponse> listMandates(String customerId) throws MollieException {
        return this.listMandates(customerId, new QueryParams());
    }

    public Pagination<MandateListResponse> listMandates(String customerId, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/mandates";
            HttpResponse<String> response = this.get(uri, params, true);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<MandateListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

