/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.common.Pagination;
import be.woutschoovaerts.mollie.data.customer.CustomerListResponse;
import be.woutschoovaerts.mollie.data.customer.CustomerRequest;
import be.woutschoovaerts.mollie.data.customer.CustomerResponse;
import be.woutschoovaerts.mollie.data.payment.PaymentListResponse;
import be.woutschoovaerts.mollie.data.payment.PaymentRequest;
import be.woutschoovaerts.mollie.data.payment.PaymentResponse;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomerHandler.class);

    public CustomerHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public CustomerResponse createCustomer(CustomerRequest body) throws MollieException {
        return this.createCustomer(body, new QueryParams());
    }

    public CustomerResponse createCustomer(CustomerRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/customers";
            HttpResponse<String> response = this.post(uri, body, params);
            return (CustomerResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), CustomerResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public CustomerResponse getCustomer(String customerId) throws MollieException {
        return this.getCustomer(customerId, new QueryParams());
    }

    public CustomerResponse getCustomer(String customerId, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId;
            HttpResponse<String> response = this.get(uri, params, true);
            return (CustomerResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), CustomerResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public CustomerResponse updateCustomer(String customerId, CustomerRequest body) throws MollieException {
        return this.updateCustomer(customerId, body, new QueryParams());
    }

    public CustomerResponse updateCustomer(String customerId, CustomerRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId;
            HttpResponse<String> response = this.patch(uri, body, params);
            return (CustomerResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), CustomerResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void deleteCustomer(String customerId) throws MollieException {
        this.deleteCustomer(customerId, new QueryParams());
    }

    public void deleteCustomer(String customerId, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId;
            HttpResponse<String> httpResponse = this.delete(uri, params, true);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<CustomerListResponse> listCustomers() throws MollieException {
        return this.listCustomers(new QueryParams());
    }

    public Pagination<CustomerListResponse> listCustomers(QueryParams params) throws MollieException {
        try {
            String uri = "/customers";
            HttpResponse<String> response = this.get(uri, params, true);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<CustomerListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public PaymentResponse createCustomerPayment(String customerId, PaymentRequest body) throws MollieException {
        return this.createCustomerPayment(customerId, body, new QueryParams());
    }

    public PaymentResponse createCustomerPayment(String customerId, PaymentRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/payments";
            HttpResponse<String> response = this.post(uri, body, params);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<PaymentListResponse> listCustomerPayments(String customerId) throws MollieException {
        return this.listCustomerPayments(customerId, new QueryParams());
    }

    public Pagination<PaymentListResponse> listCustomerPayments(String customerId, QueryParams params) throws MollieException {
        try {
            String uri = "/customers/" + customerId + "/payments";
            HttpResponse<String> response = this.get(uri, params, true);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PaymentListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

