/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.chargeback.ChargebackListResponse;
import be.woutschoovaerts.mollie.data.chargeback.ChargebackResponse;
import be.woutschoovaerts.mollie.data.common.Pagination;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargebackHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ChargebackHandler.class);

    public ChargebackHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public ChargebackResponse getChargeback(String paymentId, String chargebackId) throws MollieException {
        return this.getChargeback(paymentId, chargebackId, new QueryParams());
    }

    public ChargebackResponse getChargeback(String paymentId, String chargebackId, QueryParams params) throws MollieException {
        try {
            String uri = "/payments/" + paymentId + "/chargebacks/" + chargebackId;
            HttpResponse<String> response = this.get(uri, params, false);
            return (ChargebackResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<ChargebackResponse>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<ChargebackListResponse> listChargebacks() throws MollieException {
        return this.listChargebacks(new QueryParams());
    }

    public Pagination<ChargebackListResponse> listChargebacks(QueryParams params) throws MollieException {
        try {
            String uri = "/chargebacks";
            HttpResponse<String> response = this.get(uri, params, false);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<ChargebackListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<ChargebackListResponse> listChargebacks(String paymentId) throws MollieException {
        return this.listChargebacks(paymentId, new QueryParams());
    }

    public Pagination<ChargebackListResponse> listChargebacks(String paymentId, QueryParams params) throws MollieException {
        try {
            String uri = "/payments/" + paymentId + "/chargebacks";
            HttpResponse<String> response = this.get(uri, params, false);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<ChargebackListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

