/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.data.order;

import be.woutschoovaerts.mollie.data.common.Amount;
import be.woutschoovaerts.mollie.data.common.Locale;
import be.woutschoovaerts.mollie.data.order.OrderAddressRequest;
import be.woutschoovaerts.mollie.data.order.OrderLineRequest;
import be.woutschoovaerts.mollie.data.payment.PaymentMethod;
import be.woutschoovaerts.mollie.serializer.PaymentMethodSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OrderRequest {
    private Amount amount;
    private String orderNumber;
    private List<OrderLineRequest> lines;
    private OrderAddressRequest billingAddress;
    private Optional<OrderAddressRequest> shippingAddress;
    private Optional<LocalDate> consumerDateOfBirth;
    private Optional<String> redirectUrl;
    private Optional<String> webhookUrl;
    private Locale locale;
    @JsonSerialize(using=PaymentMethodSerializer.class)
    private Optional<List<PaymentMethod>> method;
    private Map<String, Object> payment;
    private Map<String, Object> metadata;
    private Optional<LocalDate> expiresAt = Optional.empty();
    private Optional<String> profileId;
    private Optional<Boolean> testmode;

    private static Optional<OrderAddressRequest> $default$shippingAddress() {
        return Optional.empty();
    }

    private static Optional<LocalDate> $default$consumerDateOfBirth() {
        return Optional.empty();
    }

    private static Optional<String> $default$redirectUrl() {
        return Optional.empty();
    }

    private static Optional<String> $default$webhookUrl() {
        return Optional.empty();
    }

    private static Optional<List<PaymentMethod>> $default$method() {
        return Optional.empty();
    }

    private static Optional<String> $default$profileId() {
        return Optional.empty();
    }

    private static Optional<Boolean> $default$testmode() {
        return Optional.empty();
    }

    public static OrderRequestBuilder builder() {
        return new OrderRequestBuilder();
    }

    public Amount getAmount() {
        return this.amount;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public List<OrderLineRequest> getLines() {
        return this.lines;
    }

    public OrderAddressRequest getBillingAddress() {
        return this.billingAddress;
    }

    public Optional<OrderAddressRequest> getShippingAddress() {
        return this.shippingAddress;
    }

    public Optional<LocalDate> getConsumerDateOfBirth() {
        return this.consumerDateOfBirth;
    }

    public Optional<String> getRedirectUrl() {
        return this.redirectUrl;
    }

    public Optional<String> getWebhookUrl() {
        return this.webhookUrl;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Optional<List<PaymentMethod>> getMethod() {
        return this.method;
    }

    public Map<String, Object> getPayment() {
        return this.payment;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Optional<LocalDate> getExpiresAt() {
        return this.expiresAt;
    }

    public Optional<String> getProfileId() {
        return this.profileId;
    }

    public Optional<Boolean> getTestmode() {
        return this.testmode;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setLines(List<OrderLineRequest> lines) {
        this.lines = lines;
    }

    public void setBillingAddress(OrderAddressRequest billingAddress) {
        this.billingAddress = billingAddress;
    }

    public void setShippingAddress(Optional<OrderAddressRequest> shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public void setConsumerDateOfBirth(Optional<LocalDate> consumerDateOfBirth) {
        this.consumerDateOfBirth = consumerDateOfBirth;
    }

    public void setRedirectUrl(Optional<String> redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setWebhookUrl(Optional<String> webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMethod(Optional<List<PaymentMethod>> method) {
        this.method = method;
    }

    public void setPayment(Map<String, Object> payment) {
        this.payment = payment;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void setExpiresAt(Optional<LocalDate> expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setProfileId(Optional<String> profileId) {
        this.profileId = profileId;
    }

    public void setTestmode(Optional<Boolean> testmode) {
        this.testmode = testmode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderRequest)) {
            return false;
        }
        OrderRequest other = (OrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Amount this$amount = this.getAmount();
        Amount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$orderNumber = this.getOrderNumber();
        String other$orderNumber = other.getOrderNumber();
        if (this$orderNumber == null ? other$orderNumber != null : !this$orderNumber.equals(other$orderNumber)) {
            return false;
        }
        List<OrderLineRequest> this$lines = this.getLines();
        List<OrderLineRequest> other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        OrderAddressRequest this$billingAddress = this.getBillingAddress();
        OrderAddressRequest other$billingAddress = other.getBillingAddress();
        if (this$billingAddress == null ? other$billingAddress != null : !((Object)this$billingAddress).equals(other$billingAddress)) {
            return false;
        }
        Optional<OrderAddressRequest> this$shippingAddress = this.getShippingAddress();
        Optional<OrderAddressRequest> other$shippingAddress = other.getShippingAddress();
        if (this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress)) {
            return false;
        }
        Optional<LocalDate> this$consumerDateOfBirth = this.getConsumerDateOfBirth();
        Optional<LocalDate> other$consumerDateOfBirth = other.getConsumerDateOfBirth();
        if (this$consumerDateOfBirth == null ? other$consumerDateOfBirth != null : !((Object)this$consumerDateOfBirth).equals(other$consumerDateOfBirth)) {
            return false;
        }
        Optional<String> this$redirectUrl = this.getRedirectUrl();
        Optional<String> other$redirectUrl = other.getRedirectUrl();
        if (this$redirectUrl == null ? other$redirectUrl != null : !((Object)this$redirectUrl).equals(other$redirectUrl)) {
            return false;
        }
        Optional<String> this$webhookUrl = this.getWebhookUrl();
        Optional<String> other$webhookUrl = other.getWebhookUrl();
        if (this$webhookUrl == null ? other$webhookUrl != null : !((Object)this$webhookUrl).equals(other$webhookUrl)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)((Object)this$locale)).equals((Object)other$locale)) {
            return false;
        }
        Optional<List<PaymentMethod>> this$method = this.getMethod();
        Optional<List<PaymentMethod>> other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        Map<String, Object> this$payment = this.getPayment();
        Map<String, Object> other$payment = other.getPayment();
        if (this$payment == null ? other$payment != null : !((Object)this$payment).equals(other$payment)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Optional<LocalDate> this$expiresAt = this.getExpiresAt();
        Optional<LocalDate> other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Optional<String> this$profileId = this.getProfileId();
        Optional<String> other$profileId = other.getProfileId();
        if (this$profileId == null ? other$profileId != null : !((Object)this$profileId).equals(other$profileId)) {
            return false;
        }
        Optional<Boolean> this$testmode = this.getTestmode();
        Optional<Boolean> other$testmode = other.getTestmode();
        return !(this$testmode == null ? other$testmode != null : !((Object)this$testmode).equals(other$testmode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Amount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $orderNumber = this.getOrderNumber();
        result = result * 59 + ($orderNumber == null ? 43 : $orderNumber.hashCode());
        List<OrderLineRequest> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        OrderAddressRequest $billingAddress = this.getBillingAddress();
        result = result * 59 + ($billingAddress == null ? 43 : ((Object)$billingAddress).hashCode());
        Optional<OrderAddressRequest> $shippingAddress = this.getShippingAddress();
        result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
        Optional<LocalDate> $consumerDateOfBirth = this.getConsumerDateOfBirth();
        result = result * 59 + ($consumerDateOfBirth == null ? 43 : ((Object)$consumerDateOfBirth).hashCode());
        Optional<String> $redirectUrl = this.getRedirectUrl();
        result = result * 59 + ($redirectUrl == null ? 43 : ((Object)$redirectUrl).hashCode());
        Optional<String> $webhookUrl = this.getWebhookUrl();
        result = result * 59 + ($webhookUrl == null ? 43 : ((Object)$webhookUrl).hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)((Object)$locale)).hashCode());
        Optional<List<PaymentMethod>> $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        Map<String, Object> $payment = this.getPayment();
        result = result * 59 + ($payment == null ? 43 : ((Object)$payment).hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Optional<LocalDate> $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Optional<String> $profileId = this.getProfileId();
        result = result * 59 + ($profileId == null ? 43 : ((Object)$profileId).hashCode());
        Optional<Boolean> $testmode = this.getTestmode();
        result = result * 59 + ($testmode == null ? 43 : ((Object)$testmode).hashCode());
        return result;
    }

    public String toString() {
        return "OrderRequest(amount=" + this.getAmount() + ", orderNumber=" + this.getOrderNumber() + ", lines=" + this.getLines() + ", billingAddress=" + this.getBillingAddress() + ", shippingAddress=" + this.getShippingAddress() + ", consumerDateOfBirth=" + this.getConsumerDateOfBirth() + ", redirectUrl=" + this.getRedirectUrl() + ", webhookUrl=" + this.getWebhookUrl() + ", locale=" + (Object)((Object)this.getLocale()) + ", method=" + this.getMethod() + ", payment=" + this.getPayment() + ", metadata=" + this.getMetadata() + ", expiresAt=" + this.getExpiresAt() + ", profileId=" + this.getProfileId() + ", testmode=" + this.getTestmode() + ")";
    }

    public OrderRequest(Amount amount, String orderNumber, List<OrderLineRequest> lines, OrderAddressRequest billingAddress, Optional<OrderAddressRequest> shippingAddress, Optional<LocalDate> consumerDateOfBirth, Optional<String> redirectUrl, Optional<String> webhookUrl, Locale locale, Optional<List<PaymentMethod>> method, Map<String, Object> payment, Map<String, Object> metadata, Optional<LocalDate> expiresAt, Optional<String> profileId, Optional<Boolean> testmode) {
        this.amount = amount;
        this.orderNumber = orderNumber;
        this.lines = lines;
        this.billingAddress = billingAddress;
        this.shippingAddress = shippingAddress;
        this.consumerDateOfBirth = consumerDateOfBirth;
        this.redirectUrl = redirectUrl;
        this.webhookUrl = webhookUrl;
        this.locale = locale;
        this.method = method;
        this.payment = payment;
        this.metadata = metadata;
        this.expiresAt = expiresAt;
        this.profileId = profileId;
        this.testmode = testmode;
    }

    public OrderRequest() {
        this.shippingAddress = OrderRequest.$default$shippingAddress();
        this.consumerDateOfBirth = OrderRequest.$default$consumerDateOfBirth();
        this.redirectUrl = OrderRequest.$default$redirectUrl();
        this.webhookUrl = OrderRequest.$default$webhookUrl();
        this.method = OrderRequest.$default$method();
        this.profileId = OrderRequest.$default$profileId();
        this.testmode = OrderRequest.$default$testmode();
    }

    public static class OrderRequestBuilder {
        private Amount amount;
        private String orderNumber;
        private List<OrderLineRequest> lines;
        private OrderAddressRequest billingAddress;
        private boolean shippingAddress$set;
        private Optional<OrderAddressRequest> shippingAddress$value;
        private boolean consumerDateOfBirth$set;
        private Optional<LocalDate> consumerDateOfBirth$value;
        private boolean redirectUrl$set;
        private Optional<String> redirectUrl$value;
        private boolean webhookUrl$set;
        private Optional<String> webhookUrl$value;
        private Locale locale;
        private boolean method$set;
        private Optional<List<PaymentMethod>> method$value;
        private Map<String, Object> payment;
        private Map<String, Object> metadata;
        private Optional<LocalDate> expiresAt;
        private boolean profileId$set;
        private Optional<String> profileId$value;
        private boolean testmode$set;
        private Optional<Boolean> testmode$value;

        OrderRequestBuilder() {
        }

        public OrderRequestBuilder amount(Amount amount) {
            this.amount = amount;
            return this;
        }

        public OrderRequestBuilder orderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            return this;
        }

        public OrderRequestBuilder lines(List<OrderLineRequest> lines) {
            this.lines = lines;
            return this;
        }

        public OrderRequestBuilder billingAddress(OrderAddressRequest billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public OrderRequestBuilder shippingAddress(Optional<OrderAddressRequest> shippingAddress) {
            this.shippingAddress$value = shippingAddress;
            this.shippingAddress$set = true;
            return this;
        }

        public OrderRequestBuilder consumerDateOfBirth(Optional<LocalDate> consumerDateOfBirth) {
            this.consumerDateOfBirth$value = consumerDateOfBirth;
            this.consumerDateOfBirth$set = true;
            return this;
        }

        public OrderRequestBuilder redirectUrl(Optional<String> redirectUrl) {
            this.redirectUrl$value = redirectUrl;
            this.redirectUrl$set = true;
            return this;
        }

        public OrderRequestBuilder webhookUrl(Optional<String> webhookUrl) {
            this.webhookUrl$value = webhookUrl;
            this.webhookUrl$set = true;
            return this;
        }

        public OrderRequestBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public OrderRequestBuilder method(Optional<List<PaymentMethod>> method) {
            this.method$value = method;
            this.method$set = true;
            return this;
        }

        public OrderRequestBuilder payment(Map<String, Object> payment) {
            this.payment = payment;
            return this;
        }

        public OrderRequestBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public OrderRequestBuilder expiresAt(Optional<LocalDate> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public OrderRequestBuilder profileId(Optional<String> profileId) {
            this.profileId$value = profileId;
            this.profileId$set = true;
            return this;
        }

        public OrderRequestBuilder testmode(Optional<Boolean> testmode) {
            this.testmode$value = testmode;
            this.testmode$set = true;
            return this;
        }

        public OrderRequest build() {
            Optional shippingAddress$value = this.shippingAddress$value;
            if (!this.shippingAddress$set) {
                shippingAddress$value = OrderRequest.$default$shippingAddress();
            }
            Optional consumerDateOfBirth$value = this.consumerDateOfBirth$value;
            if (!this.consumerDateOfBirth$set) {
                consumerDateOfBirth$value = OrderRequest.$default$consumerDateOfBirth();
            }
            Optional redirectUrl$value = this.redirectUrl$value;
            if (!this.redirectUrl$set) {
                redirectUrl$value = OrderRequest.$default$redirectUrl();
            }
            Optional webhookUrl$value = this.webhookUrl$value;
            if (!this.webhookUrl$set) {
                webhookUrl$value = OrderRequest.$default$webhookUrl();
            }
            Optional method$value = this.method$value;
            if (!this.method$set) {
                method$value = OrderRequest.$default$method();
            }
            Optional profileId$value = this.profileId$value;
            if (!this.profileId$set) {
                profileId$value = OrderRequest.$default$profileId();
            }
            Optional testmode$value = this.testmode$value;
            if (!this.testmode$set) {
                testmode$value = OrderRequest.$default$testmode();
            }
            return new OrderRequest(this.amount, this.orderNumber, this.lines, this.billingAddress, shippingAddress$value, consumerDateOfBirth$value, redirectUrl$value, webhookUrl$value, this.locale, method$value, this.payment, this.metadata, this.expiresAt, profileId$value, testmode$value);
        }

        public String toString() {
            return "OrderRequest.OrderRequestBuilder(amount=" + this.amount + ", orderNumber=" + this.orderNumber + ", lines=" + this.lines + ", billingAddress=" + this.billingAddress + ", shippingAddress$value=" + this.shippingAddress$value + ", consumerDateOfBirth$value=" + this.consumerDateOfBirth$value + ", redirectUrl$value=" + this.redirectUrl$value + ", webhookUrl$value=" + this.webhookUrl$value + ", locale=" + (Object)((Object)this.locale) + ", method$value=" + this.method$value + ", payment=" + this.payment + ", metadata=" + this.metadata + ", expiresAt=" + this.expiresAt + ", profileId$value=" + this.profileId$value + ", testmode$value=" + this.testmode$value + ")";
        }
    }
}

