/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie;

import be.woutschoovaerts.mollie.Client;
import be.woutschoovaerts.mollie.ClientProxy;

public final class ClientBuilder {
    private String apiKey;
    private String organizationToken;
    private boolean testMode = false;
    private String userAgentString;
    private ClientProxy proxy;

    public ClientBuilder withApiKey(String key) {
        this.apiKey = key;
        return this;
    }

    public ClientBuilder withOrganizationToken(String token) {
        this.organizationToken = token;
        return this;
    }

    public ClientBuilder withTestMode(boolean shouldBeTestMode) {
        this.testMode = shouldBeTestMode;
        return this;
    }

    public ClientBuilder withUserAgent(String customUserAgentString) {
        this.userAgentString = customUserAgentString;
        return this;
    }

    public ClientBuilder withProxy(ClientProxy clientProxy) {
        this.proxy = clientProxy;
        return this;
    }

    public Client build() {
        Client client;
        if (this.apiKey == null) {
            throw new IllegalArgumentException("API key not set. Please use withApiKey(key)");
        }
        Client client2 = client = this.proxy != null ? new Client(this.apiKey, this.proxy) : new Client(this.apiKey);
        if (this.organizationToken != null) {
            client.setAccessToken(this.organizationToken);
        }
        if (this.testMode) {
            client.enableTestMode();
        }
        if (this.userAgentString != null) {
            client.setUserAgentString(this.userAgentString);
        }
        return client;
    }
}

