/*
 * Decompiled with CFR 0.152.
 */
package be.wegenenverkeer.rxhttp;

import be.wegenenverkeer.rxhttp.AsyncCompletionHandlerWrapper;
import be.wegenenverkeer.rxhttp.AsyncHandlerWrapper;
import be.wegenenverkeer.rxhttp.ClientRequest;
import be.wegenenverkeer.rxhttp.ClientRequestBuilder;
import be.wegenenverkeer.rxhttp.CompleteResponseHandler;
import be.wegenenverkeer.rxhttp.ServerResponse;
import be.wegenenverkeer.rxhttp.ServerResponseElement;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.subjects.AsyncSubject;
import rx.subjects.BehaviorSubject;

public class RxHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(RxHttpClient.class);
    private final AsyncHttpClient innerClient;
    private final RestClientConfig config;

    protected RxHttpClient(AsyncHttpClient asyncHttpClient, RestClientConfig restClientConfig) {
        this.innerClient = asyncHttpClient;
        this.config = restClientConfig;
    }

    public <F> CompletableFuture<F> execute(ClientRequest clientRequest, final Function<ServerResponse, F> function) {
        logger.info("Sending Request: " + clientRequest.toString());
        final CompletableFuture completableFuture = new CompletableFuture();
        this.innerClient.executeRequest(clientRequest.unwrap(), (AsyncHandler)new AsyncCompletionHandler<F>(){

            public F onCompleted(Response response) throws Exception {
                try {
                    CompleteResponseHandler.withCompleteResponse(response, response2 -> {
                        Object r = function.apply(ServerResponse.wrap(response));
                        completableFuture.complete(r);
                    }, completableFuture::completeExceptionally, completableFuture::completeExceptionally);
                }
                catch (Throwable throwable) {
                    logger.error("onError handler failed: " + throwable.getMessage(), throwable);
                    completableFuture.completeExceptionally(throwable);
                }
                return null;
            }

            public void onThrowable(Throwable throwable) {
                super.onThrowable(throwable);
                completableFuture.completeExceptionally(throwable);
            }
        });
        return completableFuture;
    }

    public <F> Observable<F> executeToCompletion(ClientRequest clientRequest, Function<ServerResponse, F> function) {
        logger.info("Sending Request: " + clientRequest.toString());
        AsyncSubject asyncSubject = AsyncSubject.create();
        this.innerClient.executeRequest(clientRequest.unwrap(), new AsyncCompletionHandlerWrapper<F>(asyncSubject, function));
        return asyncSubject;
    }

    public Observable<ServerResponseElement> executeObservably(ClientRequest clientRequest) {
        return Observable.defer(() -> {
            BehaviorSubject behaviorSubject = BehaviorSubject.create();
            this.innerClient.executeRequest(clientRequest.unwrap(), (AsyncHandler)new AsyncHandlerWrapper((BehaviorSubject<ServerResponseElement>)behaviorSubject));
            return behaviorSubject;
        });
    }

    public <F> Observable<F> executeObservably(ClientRequest clientRequest, Function<byte[], F> function) {
        return Observable.defer(() -> {
            BehaviorSubject behaviorSubject = BehaviorSubject.create();
            this.innerClient.executeRequest(clientRequest.unwrap(), (AsyncHandler)new AsyncHandlerWrapper((BehaviorSubject<ServerResponseElement>)behaviorSubject));
            return behaviorSubject.filter(serverResponseElement -> serverResponseElement.match(serverResponseStatus -> false, serverResponseHeaders -> false, serverResponseBodyPart -> true, serverResponse -> true)).map(serverResponseElement -> serverResponseElement.match(serverResponseStatus -> null, serverResponseHeaders -> null, serverResponseBodyPart -> function.apply(serverResponseBodyPart.getBodyPartBytes()), serverResponse -> function.apply(serverResponse.getResponseBodyAsBytes())));
        });
    }

    public String getBaseUrl() {
        return this.config.getBaseUrl();
    }

    public String getAccept() {
        return this.config.getAccept();
    }

    public void close() {
        this.innerClient.close();
    }

    public ClientRequestBuilder requestBuilder() {
        return new ClientRequestBuilder(this);
    }

    public static class Builder {
        private AsyncHttpClientConfig.Builder configBuilder = new AsyncHttpClientConfig.Builder();
        private final RestClientConfig rcConfig = new RestClientConfig();

        public RxHttpClient build() {
            return new RxHttpClient(new AsyncHttpClient(this.configBuilder.build()), this.rcConfig);
        }

        public Builder setAccept(String string) {
            this.rcConfig.setAccept(string);
            return this;
        }

        public Builder setBaseUrl(String string) {
            this.rcConfig.setBaseUrl(string);
            return this;
        }

        public Builder setMaxConnections(int n) {
            this.configBuilder.setMaxConnections(n);
            return this;
        }

        public Builder setAllowPoolingConnections(boolean bl) {
            this.configBuilder.setAllowPoolingConnections(bl);
            return this;
        }

        public Builder setConnectTimeout(int n) {
            this.configBuilder.setConnectTimeout(n);
            return this;
        }

        public Builder setExecutorService(ExecutorService executorService) {
            this.configBuilder.setExecutorService(executorService);
            return this;
        }

        public Builder setWebSocketTimeout(int n) {
            this.configBuilder.setWebSocketTimeout(n);
            return this;
        }

        public Builder setMaxRequestRetry(int n) {
            this.configBuilder.setMaxRequestRetry(n);
            return this;
        }

        public Builder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.configBuilder.setHostnameVerifier(hostnameVerifier);
            return this;
        }

        public Builder setEnabledProtocols(String[] stringArray) {
            this.configBuilder.setEnabledProtocols(stringArray);
            return this;
        }

        public Builder setUseRelativeURIsWithConnectProxies(boolean bl) {
            this.configBuilder.setUseRelativeURIsWithConnectProxies(bl);
            return this;
        }

        public Builder setMaxConnectionsPerHost(int n) {
            this.configBuilder.setMaxConnectionsPerHost(n);
            return this;
        }

        public Builder setEnabledCipherSuites(String[] stringArray) {
            this.configBuilder.setEnabledCipherSuites(stringArray);
            return this;
        }

        public Builder setAllowPoolingSslConnections(boolean bl) {
            this.configBuilder.setAllowPoolingSslConnections(bl);
            return this;
        }

        public Builder setUseProxyProperties(boolean bl) {
            this.configBuilder.setUseProxyProperties(bl);
            return this;
        }

        public Builder setUseProxySelector(boolean bl) {
            this.configBuilder.setUseProxySelector(bl);
            return this;
        }

        public Builder setMaxRedirects(int n) {
            this.configBuilder.setMaxRedirects(n);
            return this;
        }

        public Builder setAcceptAnyCertificate(boolean bl) {
            this.configBuilder.setAcceptAnyCertificate(bl);
            return this;
        }

        public Builder setIOThreadMultiplier(int n) {
            this.configBuilder.setIOThreadMultiplier(n);
            return this;
        }

        public Builder setStrict302Handling(boolean bl) {
            this.configBuilder.setStrict302Handling(bl);
            return this;
        }

        public Builder setConnectionTTL(int n) {
            this.configBuilder.setConnectionTTL(n);
            return this;
        }

        public Builder setUserAgent(String string) {
            this.configBuilder.setUserAgent(string);
            return this;
        }

        public Builder setFollowRedirect(boolean bl) {
            this.configBuilder.setFollowRedirect(bl);
            return this;
        }

        public Builder setRemoveQueryParamsOnRedirect(boolean bl) {
            this.configBuilder.setRemoveQueryParamsOnRedirect(bl);
            return this;
        }

        public Builder setDisableUrlEncodingForBoundedRequests(boolean bl) {
            this.configBuilder.setDisableUrlEncodingForBoundedRequests(bl);
            return this;
        }

        public Builder setRequestTimeout(int n) {
            this.configBuilder.setRequestTimeout(n);
            return this;
        }

        public Builder setSSLContext(SSLContext sSLContext) {
            this.configBuilder.setSSLContext(sSLContext);
            return this;
        }

        public Builder setCompressionEnforced(boolean bl) {
            this.configBuilder.setCompressionEnforced(bl);
            return this;
        }

        public Builder setPooledConnectionIdleTimeout(int n) {
            this.configBuilder.setPooledConnectionIdleTimeout(n);
            return this;
        }

        public Builder setReadTimeout(int n) {
            this.configBuilder.setReadTimeout(n);
            return this;
        }
    }

    static class RestClientConfig {
        private String baseUrl = "http://localhost";
        private String Accept = "application/json";

        RestClientConfig() {
        }

        public void setBaseUrl(String string) {
            this.baseUrl = RestClientConfig.chopLastForwardSlash(string);
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getAccept() {
            return this.Accept;
        }

        public void setAccept(String string) {
            this.Accept = string;
        }

        private static String chopLastForwardSlash(String string) {
            if (string.charAt(string.length() - 1) == '/') {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
    }
}

