/*
 * Decompiled with CFR 0.152.
 */
package be.wegenenverkeer.rxhttp;

import be.wegenenverkeer.rxhttp.ServerResponseElement;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class MutableResponseProcessor {
    private int statusCode;
    private Optional<String> statusText;
    private Map<String, List<String>> headers;

    public void process(ServerResponseElement serverResponseElement) {
        serverResponseElement.match(serverResponseStatus -> {
            this.statusCode = serverResponseStatus.getStatusCode();
            this.statusText = serverResponseStatus.getStatusText();
            return true;
        }, serverResponseHeaders -> {
            this.headers = serverResponseHeaders.getHeaders();
            return true;
        }, serverResponseBodyPart -> {
            this.processPart(serverResponseBodyPart.getBodyPartBytes());
            return true;
        }, serverResponse -> {
            this.statusCode = serverResponse.getStatusCode();
            this.statusText = serverResponse.getStatusText();
            this.headers = serverResponse.getHeaders();
            this.processPart(serverResponse.getResponseBodyAsBytes());
            return true;
        });
    }

    abstract void processPart(byte[] var1);

    public int getStatusCode() {
        return this.statusCode;
    }

    public Optional<String> getStatusText() {
        return this.statusText;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }
}

