/*
 * Decompiled with CFR 0.152.
 */
package be.wegenenverkeer.rxhttp;

import be.wegenenverkeer.rxhttp.MutableResponseProcessor;
import be.wegenenverkeer.rxhttp.ServerResponseElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import rx.Subscriber;

public class CollectingSubscriber<T>
extends Subscriber<ServerResponseElement> {
    private final CompletableFuture<List<T>> cfuture = new CompletableFuture();
    private final List<T> accumulator = new ArrayList<T>();
    private final MutableResponseProcessor processor;

    public CollectingSubscriber(final Function<byte[], T> function) {
        this.processor = new MutableResponseProcessor(){

            @Override
            void processPart(byte[] byArray) {
                try {
                    CollectingSubscriber.this.accumulator.add(function.apply(byArray));
                }
                catch (Throwable throwable) {
                    CollectingSubscriber.this.cfuture.completeExceptionally(throwable);
                }
            }
        };
    }

    public void onCompleted() {
        this.cfuture.complete(Collections.unmodifiableList(this.accumulator));
    }

    public void onError(Throwable throwable) {
        this.cfuture.completeExceptionally(throwable);
    }

    public void onNext(ServerResponseElement serverResponseElement) {
        this.processor.process(serverResponseElement);
    }

    public List<T> collectImmediately() {
        this.unsubscribe();
        return new ArrayList<T>(this.accumulator);
    }

    public Future<List<T>> collect() {
        return this.cfuture;
    }
}

