/*
 * Decompiled with CFR 0.152.
 */
package be.wegenenverkeer.rxhttp;

import be.wegenenverkeer.rxhttp.ClientRequest;
import be.wegenenverkeer.rxhttp.RxHttpClient;
import com.ning.http.client.Param;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.FilePart;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.multipart.StringPart;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ClientRequestBuilder {
    private final RequestBuilder inner = new RequestBuilder();
    private final RxHttpClient client;
    private boolean hasAcceptHeader;

    ClientRequestBuilder(RxHttpClient rxHttpClient) {
        this.client = rxHttpClient;
    }

    public ClientRequest build() {
        this.sanitizeConfiguration();
        return new ClientRequest(this.inner.build());
    }

    private void sanitizeConfiguration() {
        if (!this.hasAcceptHeader) {
            this.addHeader("Accept", this.client.getAccept());
        }
    }

    public ClientRequestBuilder addByteArrayBodyPart(String string, byte[] byArray, String string2, Charset charset, String string3, String string4) {
        this.inner.addBodyPart((Part)new ByteArrayPart(string, byArray, string2, charset, string3, string4));
        return this;
    }

    public ClientRequestBuilder addFileBodyPart(String string, File file, String string2, Charset charset, String string3, String string4, String string5) {
        this.inner.addBodyPart((Part)new FilePart(string, file, string2, charset, string4, string3, string5));
        return this;
    }

    public ClientRequestBuilder addStringBodyPart(String string, String string2, String string3, Charset charset, String string4, String string5) {
        this.inner.addBodyPart((Part)new StringPart(string, string2, string3, charset, string4, string5));
        return this;
    }

    public ClientRequestBuilder setBody(File file) {
        this.inner.setBody(file);
        return this;
    }

    public ClientRequestBuilder setUrlRelativetoBase(String string) {
        this.inner.setUrl(this.toFullPath(string));
        return this;
    }

    public ClientRequestBuilder setBody(List<byte[]> list) {
        this.inner.setBody(list);
        return this;
    }

    public void resetQuery() {
        this.inner.resetQuery();
    }

    public ClientRequestBuilder addQueryParams(List<Param> list) {
        this.inner.addQueryParams(list);
        return this;
    }

    public ClientRequestBuilder addQueryParam(String string, String string2) {
        this.inner.addQueryParam(string, string2);
        return this;
    }

    public void resetNonMultipartData() {
        this.inner.resetNonMultipartData();
    }

    public ClientRequestBuilder setFormParams(Map<String, List<String>> map) {
        this.inner.setFormParams(map);
        return this;
    }

    public ClientRequestBuilder setBody(byte[] byArray) {
        this.inner.setBody(byArray);
        return this;
    }

    public ClientRequestBuilder setBody(String string) {
        this.inner.setBody(string);
        return this;
    }

    public ClientRequestBuilder setVirtualHost(String string) {
        this.inner.setVirtualHost(string);
        return this;
    }

    public ClientRequestBuilder addFormParam(String string, String string2) {
        this.inner.addFormParam(string, string2);
        return this;
    }

    public ClientRequestBuilder setHeaders(Map<String, Collection<String>> map) {
        this.inner.setHeaders(map);
        return this;
    }

    public ClientRequestBuilder setQueryParams(Map<String, List<String>> map) {
        this.inner.setQueryParams(map);
        return this;
    }

    public ClientRequestBuilder setBodyEncoding(String string) {
        this.inner.setBodyEncoding(string);
        return this;
    }

    public ClientRequestBuilder setMethod(String string) {
        this.inner.setMethod(string);
        return this;
    }

    public ClientRequestBuilder setContentLength(int n) {
        this.inner.setContentLength(n);
        return this;
    }

    public ClientRequestBuilder setRequestTimeout(int n) {
        this.inner.setRequestTimeout(n);
        return this;
    }

    public ClientRequestBuilder setRangeOffset(long l) {
        this.inner.setRangeOffset(l);
        return this;
    }

    public ClientRequestBuilder addHeader(String string, String string2) {
        if (string.equalsIgnoreCase("Accept")) {
            this.hasAcceptHeader = true;
        }
        this.inner.addHeader(string, string2);
        return this;
    }

    public void resetFormParams() {
        this.inner.resetFormParams();
    }

    public ClientRequestBuilder setHeader(String string, String string2) {
        this.inner.setHeader(string, string2);
        return this;
    }

    public void resetMultipartData() {
        this.inner.resetMultipartData();
    }

    public ClientRequestBuilder setFollowRedirects(boolean bl) {
        this.inner.setFollowRedirects(bl);
        return this;
    }

    private String toFullPath(String string) {
        String string2 = ClientRequestBuilder.chopFirstForwardSlash(string);
        return this.client.getBaseUrl() + "/" + string2;
    }

    private static String chopFirstForwardSlash(String string) {
        if (string.charAt(0) == '/') {
            string = string.substring(1, string.length());
        }
        return string;
    }
}

