/*
 * Decompiled with CFR 0.152.
 */
package be.wegenenverkeer.rxhttp;

import be.wegenenverkeer.rxhttp.HttpClientError;
import be.wegenenverkeer.rxhttp.HttpServerError;
import be.wegenenverkeer.rxhttp.ServerResponseElement;
import be.wegenenverkeer.rxhttp.ServerResponseHeadersBase;
import be.wegenenverkeer.rxhttp.ServerResponseStatus;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import java.util.Optional;
import rx.subjects.BehaviorSubject;

class AsyncHandlerWrapper
implements AsyncHandler<Boolean> {
    private final BehaviorSubject<ServerResponseElement> subject;

    AsyncHandlerWrapper(BehaviorSubject<ServerResponseElement> behaviorSubject) {
        this.subject = behaviorSubject;
    }

    public void onThrowable(Throwable throwable) {
        this.subject.onError(throwable);
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart httpResponseBodyPart) throws Exception {
        if (!this.subject.hasObservers()) {
            httpResponseBodyPart.markUnderlyingConnectionAsToBeClosed();
            this.onCompleted();
            return AsyncHandler.STATE.ABORT;
        }
        this.subject.onNext(() -> ((HttpResponseBodyPart)httpResponseBodyPart).getBodyPartBytes());
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(final HttpResponseStatus httpResponseStatus) throws Exception {
        final int n = httpResponseStatus.getStatusCode();
        if (n >= 400 && n < 500) {
            this.subject.onError((Throwable)new HttpClientError(n, null, httpResponseStatus.getStatusText()));
        } else if (n >= 500) {
            this.subject.onError((Throwable)new HttpServerError(n, null, httpResponseStatus.getStatusText()));
        }
        this.subject.onNext((Object)new ServerResponseStatus(){

            @Override
            public int getStatusCode() {
                return n;
            }

            @Override
            public Optional<String> getStatusText() {
                return Optional.ofNullable(httpResponseStatus.getStatusText());
            }
        });
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders httpResponseHeaders) throws Exception {
        this.subject.onNext((Object)new ServerResponseHeadersBase(httpResponseHeaders));
        return AsyncHandler.STATE.CONTINUE;
    }

    public Boolean onCompleted() throws Exception {
        this.subject.onCompleted();
        return true;
    }
}

