/*
 * Decompiled with CFR 0.152.
 */
package be.wegenenverkeer.rxhttp;

import be.wegenenverkeer.rxhttp.CompleteResponseHandler;
import be.wegenenverkeer.rxhttp.ServerResponse;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.Response;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.exceptions.OnErrorFailedException;
import rx.subjects.AsyncSubject;

class AsyncCompletionHandlerWrapper<F>
extends AsyncCompletionHandler<F> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncCompletionHandlerWrapper.class);
    private final AsyncSubject<? super F> subject;
    private final Function<ServerResponse, F> handler;

    AsyncCompletionHandlerWrapper(AsyncSubject<? super F> asyncSubject, Function<ServerResponse, F> function) {
        if (asyncSubject == null || function == null) {
            throw new IllegalArgumentException();
        }
        this.subject = asyncSubject;
        this.handler = function;
    }

    public F onCompleted(Response response2) throws Exception {
        try {
            CompleteResponseHandler.withCompleteResponse(response2, response -> {
                F f = this.handler.apply(ServerResponse.wrap(response));
                if (f != null) {
                    this.subject.onNext(f);
                }
                this.subject.onCompleted();
            }, throwable -> this.subject.onError(throwable), throwable -> this.subject.onError(throwable));
        }
        catch (Throwable throwable2) {
            if (throwable2 instanceof OnErrorFailedException) {
                logger.error("onError handler failed: " + throwable2.getMessage(), throwable2);
            }
            this.subject.onError(throwable2);
        }
        return null;
    }

    public void onThrowable(Throwable throwable) {
        this.subject.onError(throwable);
    }
}

