package be.personify.util.properties.provider;

import java.util.Locale;
import java.util.Map;

public abstract class EntitlementPropertyProvider {
	
	public Map<String,String> configuration;
	
	public EntitlementPropertyProvider( Map<String,String> configuration ) {
		try {
			validateConfiguration(configuration);
		}
		catch ( Exception e ) {
			throw new RuntimeException(e.getMessage());
		}
		this.configuration = configuration;
	}
	
	public abstract Map<String,String> getProperties( EntitlementPropertyFilter filter, Locale locale);
	
	public abstract void validateConfiguration(Map<String, String> configuration) throws Exception;

	
}
