package be.personify.util;

public enum ConnectorType {
	
	LDAP("be.personify.iam.provisioning.connectors.LdapConnector"),
	REST("be.personify.iam.provisioning.connectors.RestConnector"),
	MSGRAPH("be.personify.iam.provisioning.connectors.MicrosoftGraphConnector"),
	DATABASE("be.personify.iam.provisioning.connectors.DatabaseConnector"),
	SCIM("be.personify.iam.provisioning.connectors.ScimConnector"),
	SSH("be.personify.iam.provisioning.connectors.SshConnector"),
	FILE("be.personify.iam.provisioning.connectors.FileConnector"),
	PSNFYIDENTITY("be.personify.iam.provisioning.connectors.PersonifyIdentityConnector"),
	PSNFYORGASS("be.personify.iam.provisioning.connectors.PersonifyOrganisationAssignmentConnector"),
	PSNFYENTASS("be.personify.iam.provisioning.connectors.PersonifyEntitlementAssignmentConnector"),
	CUSTOM("");
	

	private String className;
	
	private ConnectorType ( String className ) {
		this.className = className;
	}

	public String getClassName() {
		return className;
	}
	
	

}
