package be.personify.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtils {
	
	public static final String DATETIMEFORMAT_ISO = "yyyy-MM-dd'T'HH:mm:ss.SSS";	
	
	public static String format( Date date ) {
		if ( date != null) {
			return new SimpleDateFormat(DATETIMEFORMAT_ISO).format(date);
		}
		return StringUtils.EMPTY_STRING;
	}
	
	
	public static Date parse( String s ) throws ParseException {
		return new SimpleDateFormat(DATETIMEFORMAT_ISO).parse(s);
	}
	
	
}
