package be.personify.util.http;

import javax.servlet.http.HttpServletRequest;

import be.personify.util.StringUtils;

/**
 * Utility class for http stuff
 * 
 * @author vanderw
 *
 */
public class HttpUtil {

	/**
	 * Gets the full url
	 * 
	 * @param request the HttpServletRequest
	 * @return the string containing the full url
	 */
	public static String getFullURL(HttpServletRequest request) {
		StringBuilder requestURL = new StringBuilder(request.getRequestURL().toString());
		String queryString = request.getQueryString();
		if (queryString == null) {
			return requestURL.toString();
		} else {
			return requestURL.append(StringUtils.QUESTION_MARK).append(queryString).toString();
		}
	}
	

	/**
	 * Detects if a request is multipart
	 * @param request the HttpServletRequest
	 * @return a boolean indicating if it is multipart
	 */
	public static final boolean isMultipart(HttpServletRequest request) {
		String contentType = request.getContentType();
		if (contentType == null) {
			return false;
		}
		if (contentType.toLowerCase().startsWith(StringUtils.MULTIPART_START)) {
			return true;
		}
		return false;
	}

}
