package be.personify.util;

import java.util.List;

public class StringUtils {
	
	
	private static final String S = "s";
	private static final String Y = "y";
	private static final String SS = "ss";
	private static final String ES = "es";
	private static final String IES = "ies";
	public static final String EMPTY_STRING = "";
	public static final String SPACE = " ";
	public static final String ZERO = "0";
	public static final String SLASH = "/";
	public static final String DASH = "-";
	public static final String PIPE = "|";
	public static final String COLON = ":";
	public static final String COMMA = ",";
	public static final String DOT = ".";
	public static final String SEMI_COLON = ";";
	public static final String QUESTION_MARK = "?";
	public static final String COLON_SLASHSLASH = "://";
	public static final String ESCAPED_PIPE = "\\|";
	
	public static final String CRLF = "\r\n";
	public static final String TWO_DASHES = "--";
	public static final String BOUNDARY =  "*****";
	
	public static final String MULTIPART_START = "multipart/";
		
		
		
	
	public static boolean isEmpty( String s ) {
		return s == null || s.length() == 0;
	}
	 
	
	public static String join(List<String> list, String delim) {

	    StringBuilder sb = new StringBuilder();

	    String loopDelim = EMPTY_STRING;

	    for(String s : list) {

	        sb.append(loopDelim);
	        sb.append(s);            

	        loopDelim = delim;
	    }

	    return sb.toString();
	}
	
	
	
	public static String capitalize( String s ) {
		return s.substring(0, 1).toUpperCase() + s.substring(1);
	}
	
	
	
	
	public static String getMultiIdentifier( String single ) {
		if ( single.endsWith(Y)) {
			return single.substring(0, single.length()-1) + IES;
		}
		if ( single.endsWith(SS)) {
			return single + ES;
		}
		return single + S;
	}
	
	
	public static String getSingleIdentifier( String multi ) {
		if ( multi.endsWith(IES)) {
			return multi.substring(0, multi.length() -3) + Y;
		}
		return multi.substring(0, multi.length() -1);
	}
	
	

}
