/*
 * Decompiled with CFR 0.152.
 */
package urldsl.language;

import scala.;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import urldsl.language.Fragment;
import urldsl.language.PathQueryFragmentRepr;
import urldsl.language.PathSegment;
import urldsl.language.QueryParameters;
import urldsl.language.Tupler;
import urldsl.language.UrlPart;
import urldsl.url.UrlStringDecoder;
import urldsl.url.UrlStringDecoder$;
import urldsl.url.UrlStringGenerator;
import urldsl.url.UrlStringGenerator$;
import urldsl.url.UrlStringParserGenerator;
import urldsl.url.UrlStringParserGenerator$;
import urldsl.vocabulary.ParamMatchOutput;
import urldsl.vocabulary.ParamMatchOutput$;
import urldsl.vocabulary.PathMatchOutput;
import urldsl.vocabulary.PathMatchOutput$;
import urldsl.vocabulary.UrlMatching;
import urldsl.vocabulary.UrlMatching$;

public final class PathSegmentWithQueryParams<PathType, PathError, ParamsType, ParamsError>
implements UrlPart<UrlMatching<PathType, ParamsType>, Either<PathError, ParamsError>> {
    private final PathSegment<PathType, PathError> pathSegment;
    private final QueryParameters<ParamsType, ParamsError> queryParams;

    public PathSegmentWithQueryParams(PathSegment<PathType, PathError> pathSegment, QueryParameters<ParamsType, ParamsError> queryParams) {
        this.pathSegment = pathSegment;
        this.queryParams = queryParams;
    }

    public Either<Either<PathError, ParamsError>, UrlMatching<PathType, ParamsType>> matchUrl(List<String> path, Map<String, List> params) {
        PathMatchOutput pathMatchOutput;
        Either<PathError, PathMatchOutput<PathType>> either = this.pathSegment.matchSegments(path);
        if (either instanceof Left) {
            Object error = ((Left)either).value();
            return package$.MODULE$.Left().apply((Object)package$.MODULE$.Left().apply(error));
        }
        if (either instanceof Right && (pathMatchOutput = (PathMatchOutput)((Right)either).value()) != null) {
            ParamMatchOutput paramMatchOutput;
            PathMatchOutput pathMatchOutput2 = PathMatchOutput$.MODULE$.unapply(pathMatchOutput);
            Object t = pathMatchOutput2._1();
            List<String> list = pathMatchOutput2._2();
            Object pathOut = t;
            Either<ParamsError, ParamMatchOutput<ParamsType>> either2 = this.queryParams.matchParams(params);
            if (either2 instanceof Left) {
                Object error = ((Left)either2).value();
                return package$.MODULE$.Left().apply((Object)package$.MODULE$.Right().apply(error));
            }
            if (either2 instanceof Right && (paramMatchOutput = (ParamMatchOutput)((Right)either2).value()) != null) {
                ParamMatchOutput paramMatchOutput2 = ParamMatchOutput$.MODULE$.unapply(paramMatchOutput);
                Object q = paramMatchOutput2._1();
                Map<String, List> map = paramMatchOutput2._2();
                Object paramsOut = q;
                return package$.MODULE$.Right().apply(UrlMatching$.MODULE$.apply(pathOut, paramsOut));
            }
            throw new MatchError(either2);
        }
        throw new MatchError(either);
    }

    @Override
    public Either<Either<PathError, ParamsError>, UrlMatching<PathType, ParamsType>> matchRawUrl(String url, UrlStringParserGenerator parserGenerator) {
        Either<PathError, PathType> either = this.pathSegment.matchRawUrl(url, parserGenerator);
        if (either instanceof Left) {
            Object error = ((Left)either).value();
            return package$.MODULE$.Left().apply((Object)package$.MODULE$.Left().apply(error));
        }
        if (either instanceof Right) {
            Object pathOutput = ((Right)either).value();
            Either<ParamsError, ParamsType> either2 = this.queryParams.matchRawUrl(url, parserGenerator);
            if (either2 instanceof Left) {
                Object error = ((Left)either2).value();
                return package$.MODULE$.Left().apply((Object)package$.MODULE$.Right().apply(error));
            }
            if (either2 instanceof Right) {
                Object paramsOutput = ((Right)either2).value();
                return package$.MODULE$.Right().apply(UrlMatching$.MODULE$.apply(pathOutput, paramsOutput));
            }
            throw new MatchError(either2);
        }
        throw new MatchError(either);
    }

    @Override
    public UrlStringParserGenerator matchRawUrl$default$2() {
        return UrlStringParserGenerator$.MODULE$.defaultUrlStringParserGenerator();
    }

    public Option<UrlMatching<PathType, ParamsType>> matchRawUrlOption(String url, UrlStringParserGenerator parserGenerator) {
        return this.matchRawUrl(url, parserGenerator).toOption();
    }

    public UrlStringParserGenerator matchRawUrlOption$default$2() {
        return UrlStringParserGenerator$.MODULE$.defaultUrlStringParserGenerator();
    }

    public Either<Either<PathError, ParamsError>, UrlMatching<PathType, ParamsType>> matchPathAndQuery(String path, String queryString, UrlStringDecoder decoder) {
        Either<PathError, PathType> either = this.pathSegment.matchPath(path, decoder);
        if (either instanceof Left) {
            Object error = ((Left)either).value();
            return package$.MODULE$.Left().apply((Object)package$.MODULE$.Left().apply(error));
        }
        if (either instanceof Right) {
            Object pathOutput = ((Right)either).value();
            Either<ParamsError, ParamsType> either2 = this.queryParams.matchQueryString(queryString, decoder);
            if (either2 instanceof Left) {
                Object error = ((Left)either2).value();
                return package$.MODULE$.Left().apply((Object)package$.MODULE$.Right().apply(error));
            }
            if (either2 instanceof Right) {
                Object paramsOutput = ((Right)either2).value();
                return package$.MODULE$.Right().apply(UrlMatching$.MODULE$.apply(pathOutput, paramsOutput));
            }
            throw new MatchError(either2);
        }
        throw new MatchError(either);
    }

    public UrlStringDecoder matchPathAndQuery$default$3() {
        return UrlStringDecoder$.MODULE$.defaultDecoder();
    }

    public Option<UrlMatching<PathType, ParamsType>> matchPathAndQueryOption(String path, String queryString, UrlStringDecoder decoder) {
        return this.matchPathAndQuery(path, queryString, decoder).toOption();
    }

    public UrlStringDecoder matchPathAndQueryOption$default$3() {
        return UrlStringDecoder$.MODULE$.defaultDecoder();
    }

    public Tuple2<List<String>, Map<String, List>> createUrl(PathType path, ParamsType params) {
        return Tuple2$.MODULE$.apply(this.pathSegment.createSegments(path), this.queryParams.createParams(params));
    }

    public Tuple2<List<String>, Map<String, List>> createUrl(PathType path, .eq.colon.eq<BoxedUnit, ParamsType> ev) {
        return this.createUrl(path, ev.apply((Object)BoxedUnit.UNIT));
    }

    public String createUrlString(PathType path, ParamsType params, UrlStringGenerator generator) {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.pathSegment.createPath(path, generator)), "?")), this.queryParams.createParamsString(params, generator));
    }

    public UrlStringGenerator createUrlString$default$3() {
        return UrlStringGenerator$.MODULE$.default();
    }

    public <OtherParamsType, ParamsError1> PathSegmentWithQueryParams<PathType, PathError, Object, ParamsError1> $amp(QueryParameters<OtherParamsType, ParamsError1> otherParams, Tupler<ParamsType, OtherParamsType> ev) {
        return new PathSegmentWithQueryParams<PathType, PathError, Object, ParamsError1>(this.pathSegment, this.queryParams.$amp(otherParams, ev));
    }

    public <FragmentType, FragmentError> PathQueryFragmentRepr<PathType, PathError, ParamsType, ParamsError, FragmentType, FragmentError> withFragment(Fragment<FragmentType, FragmentError> fragment) {
        return new PathQueryFragmentRepr<PathType, PathError, ParamsType, ParamsError, FragmentType, FragmentError>(this.pathSegment, this.queryParams, fragment);
    }

    @Override
    public String createPart(UrlMatching<PathType, ParamsType> t, UrlStringGenerator encoder) {
        return this.createUrlString(t.path(), t.params(), encoder);
    }
}

