/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.hibernate;

import at.ipsquare.hibernate.ExecutionError;
import at.ipsquare.hibernate.HibernateConfiguration;
import at.ipsquare.hibernate.HibernateRepository;
import at.ipsquare.hibernate.UnitOfWork;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Driver;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultHibernateRepository
implements HibernateRepository {
    private static final Logger log = LoggerFactory.getLogger(DefaultHibernateRepository.class);
    private final SessionFactory sessionFactory;
    private final ThreadLocal<Session> currentSession = new ThreadLocal();
    private final ThreadLocal<UnitOfWork<?>> currentUnitOfWork = new ThreadLocal();

    @Inject
    public DefaultHibernateRepository(HibernateConfiguration hibernateCfg) {
        this.sessionFactory = DefaultHibernateRepository.sessionFactory(hibernateCfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeUnitOfWork(UnitOfWork<T> work) {
        if (work == null) {
            throw new NullPointerException();
        }
        if (this.currentUnitOfWork.get() != null) {
            log.info("Executing " + work + " within already running " + this.currentUnitOfWork.get() + ".");
            try {
                return work.execute();
            }
            catch (Exception e) {
                log.warn(DefaultHibernateRepository.exceptionLogMessage(work), (Throwable)e);
                throw new ExecutionError(e);
            }
        }
        log.info("Executing " + work + ".");
        Session session = this.session();
        this.currentSession.set(session);
        this.currentUnitOfWork.set(work);
        session.beginTransaction();
        try {
            T result = null;
            try {
                result = work.execute();
            }
            catch (Exception e) {
                log.warn(DefaultHibernateRepository.exceptionLogMessage(work), (Throwable)e);
                Transaction tx = DefaultHibernateRepository.getActiveTransaction(session);
                if (tx != null) {
                    tx.rollback();
                }
                throw new ExecutionError(e);
            }
            Transaction tx = DefaultHibernateRepository.getActiveTransaction(session);
            if (tx != null) {
                tx.commit();
            }
            T t = result;
            return t;
        }
        finally {
            try {
                log.info("Closing " + work + ".");
                session.close();
            }
            finally {
                this.currentSession.set(null);
                this.currentUnitOfWork.set(null);
            }
        }
    }

    private static String exceptionLogMessage(UnitOfWork<?> work) {
        return "Executing " + work + " resulted in an exception.";
    }

    private static Transaction getActiveTransaction(Session session) {
        Transaction tx = session.getTransaction();
        if (tx != null && tx.isActive()) {
            return tx;
        }
        return null;
    }

    @Override
    public Session currentSession() {
        if (this.currentUnitOfWork.get() == null) {
            throw new IllegalStateException("Attempting to access the current session without a UnitOfWork.");
        }
        if (this.currentSession.get() == null) {
            throw new AssertionError((Object)"Should be impossible.");
        }
        return this.currentSession.get();
    }

    private Session session() {
        if (this.currentSession.get() != null) {
            return this.currentSession.get();
        }
        return this.sessionFactory.openSession();
    }

    private static SessionFactory sessionFactory(HibernateConfiguration hibernateCfg) {
        return DefaultHibernateRepository.hibernateConfiguration(hibernateCfg).buildSessionFactory();
    }

    private static Configuration hibernateConfiguration(HibernateConfiguration hibernateCfg) {
        Configuration cfg = new Configuration();
        for (Class<?> domainClass : hibernateCfg.getDomainClasses()) {
            cfg.addAnnotatedClass(domainClass);
        }
        cfg.setProperty("hibernate.connection.username", hibernateCfg.getDbUser());
        cfg.setProperty("hibernate.connection.password", hibernateCfg.getDbPass());
        cfg.setProperty("hibernate.connection.url", hibernateCfg.getDbConnectionUrl());
        cfg.setProperty("hibernate.connection.driver_class", hibernateCfg.getDbDriverClass().getCanonicalName());
        cfg.setProperty("hibernate.hbm2ddl.auto", hibernateCfg.getHbm2dllAuto().toString());
        if (hibernateCfg.getProperties() != null) {
            for (Map.Entry<String, String> entry : hibernateCfg.getProperties().entrySet()) {
                cfg.setProperty(entry.getKey(), entry.getValue());
            }
        }
        DefaultHibernateRepository.explicitlyInitializeDriverClass(hibernateCfg.getDbDriverClass());
        return cfg;
    }

    private static void explicitlyInitializeDriverClass(Class<? extends Driver> clazz) {
        try {
            Class.forName(clazz.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load database driver.", e);
        }
    }
}

