/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.ChildNode;
import com.sun.org.apache.xerces.internal.dom.CoreDocumentImpl;
import com.sun.org.apache.xerces.internal.dom.EntityImpl;
import com.sun.org.apache.xerces.internal.dom.ParentNode;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EntityReferenceImpl
extends ParentNode
implements EntityReference {
    static final long serialVersionUID = -7381452955687102062L;
    protected String name;
    protected String baseURI;

    public EntityReferenceImpl(CoreDocumentImpl ownerDoc, String name) {
        super(ownerDoc);
        this.name = name;
        this.isReadOnly(true);
        this.needsSyncChildren(true);
    }

    public short getNodeType() {
        return 5;
    }

    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public Node cloneNode(boolean deep) {
        EntityReferenceImpl er = (EntityReferenceImpl)super.cloneNode(deep);
        er.setReadOnly(true, deep);
        return er;
    }

    public String getBaseURI() {
        EntityImpl entDef;
        NamedNodeMap entities;
        DocumentType doctype;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.baseURI == null && null != (doctype = this.getOwnerDocument().getDoctype()) && null != (entities = doctype.getEntities()) && (entDef = (EntityImpl)entities.getNamedItem(this.getNodeName())) != null) {
            return entDef.getBaseURI();
        }
        return this.baseURI;
    }

    public void setBaseURI(String uri) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.baseURI = uri;
    }

    protected String getEntityRefValue() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        String value = "";
        if (this.firstChild != null) {
            if (this.firstChild.getNodeType() == 5) {
                value = ((EntityReferenceImpl)this.firstChild).getEntityRefValue();
            } else if (this.firstChild.getNodeType() == 3) {
                value = this.firstChild.getNodeValue();
            } else {
                return null;
            }
            if (this.firstChild.nextSibling == null) {
                return value;
            }
            StringBuffer buff = new StringBuffer(value);
            ChildNode next = this.firstChild.nextSibling;
            while (next != null) {
                if (next.getNodeType() == 5) {
                    value = ((EntityReferenceImpl)next).getEntityRefValue();
                } else if (next.getNodeType() == 3) {
                    value = next.getNodeValue();
                } else {
                    return null;
                }
                buff.append(value);
                next = next.nextSibling;
            }
            return buff.toString();
        }
        return "";
    }

    protected void synchronizeChildren() {
        NamedNodeMap entities;
        this.needsSyncChildren(false);
        DocumentType doctype = this.getOwnerDocument().getDoctype();
        if (null != doctype && null != (entities = doctype.getEntities())) {
            EntityImpl entDef = (EntityImpl)entities.getNamedItem(this.getNodeName());
            if (entDef == null) {
                return;
            }
            this.isReadOnly(false);
            Node defkid = entDef.getFirstChild();
            while (defkid != null) {
                Node newkid = defkid.cloneNode(true);
                this.insertBefore(newkid, null);
                defkid = defkid.getNextSibling();
            }
            this.setReadOnly(true, true);
        }
    }

    public void setReadOnly(boolean readOnly, boolean deep) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (deep) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            ChildNode mykid = this.firstChild;
            while (mykid != null) {
                mykid.setReadOnly(readOnly, true);
                mykid = mykid.nextSibling;
            }
        }
        this.isReadOnly(readOnly);
    }
}

