/*
 * Decompiled with CFR 0.152.
 */
package wtf.s1.willfix.logging;

import wtf.s1.willfix.core.ILogger;
import wtf.s1.willfix.logging.SystemOutputImpl;

public class LevelLog
implements ILogger {
    public static ILogger sDefaultLogger = new LevelLog();
    public static ILogger DEFAULT = new SystemOutputImpl();
    private ILogger logger;
    private Level level = Level.INFO;

    public LevelLog() {
        this(DEFAULT);
    }

    public LevelLog(ILogger logger) {
        this.setImpl(logger);
    }

    public void setLevel(Level l) {
        this.level = l;
    }

    public void setImpl(ILogger l) {
        this.logger = l;
    }

    public ILogger getImpl() {
        return this.logger;
    }

    public void setTag(String tag) {
        this.logger.setTag(tag);
    }

    public void d(String msg) {
        if (this.level.compareTo(Level.DEBUG) <= 0) {
            this.logger.d(msg);
        }
    }

    public void d(String tag, String msg) {
        if (this.level.compareTo(Level.DEBUG) <= 0) {
            this.logger.d(tag, msg);
        }
    }

    public void i(String msg) {
        if (this.level.compareTo(Level.INFO) <= 0) {
            this.logger.i(msg);
        }
    }

    public void i(String tag, String msg) {
        if (this.level.compareTo(Level.INFO) <= 0) {
            this.logger.i(tag, msg);
        }
    }

    public void w(String msg) {
        if (this.level.compareTo(Level.WARN) <= 0) {
            this.logger.w(msg);
        }
    }

    public void w(String tag, String msg) {
        if (this.level.compareTo(Level.WARN) <= 0) {
            this.logger.w(tag, msg);
        }
    }

    public void w(String msg, Throwable t) {
        if (this.level.compareTo(Level.WARN) <= 0) {
            this.logger.w(msg, t);
        }
    }

    public void w(String tag, String msg, Throwable t) {
        if (this.level.compareTo(Level.WARN) <= 0) {
            this.logger.w(tag, msg, t);
        }
    }

    public void e(String msg) {
        if (this.level.compareTo(Level.ERROR) <= 0) {
            this.logger.e(msg);
        }
    }

    public void e(String tag, String msg) {
        if (this.level.compareTo(Level.ERROR) <= 0) {
            this.logger.e(tag, msg);
        }
    }

    public void e(String msg, Throwable t) {
        if (this.level.compareTo(Level.ERROR) <= 0) {
            this.logger.e(msg, t);
        }
    }

    public void e(String tag, String msg, Throwable t) {
        if (this.level.compareTo(Level.ERROR) <= 0) {
            this.logger.e(tag, msg, t);
        }
    }

    public static enum Level {
        DEBUG("DEBUG"),
        INFO("INFO"),
        WARN("WARN"),
        ERROR("ERROR");

        String value;

        private Level(String value) {
            this.value = value;
        }
    }
}

