/*
 * Decompiled with CFR 0.152.
 */
package wtf.s1.willfix.logging;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.gradle.api.logging.LogLevel;
import wtf.s1.willfix.core.ILogger;

public abstract class BaseLogger
implements ILogger,
Closeable {
    private static final String DEFAULT_TAG = "WillFix";
    private String tag = "WillFix";

    public void setTag(String tag) {
        this.tag = tag == null || "".equals(tag) ? DEFAULT_TAG : tag;
    }

    public void d(String msg) {
        this.d(this.tag, msg);
    }

    public void d(String tag, String msg) {
        this.write(LogLevel.DEBUG, tag, msg, null);
    }

    public void i(String msg) {
        this.i(this.tag, msg);
    }

    public void i(String tag, String msg) {
        this.write(LogLevel.INFO, tag, msg, null);
    }

    public void w(String msg) {
        this.w(this.tag, msg);
    }

    public void w(String tag, String msg) {
        this.w(tag, msg, null);
    }

    public void w(String msg, Throwable t) {
        this.w(this.tag, msg, t);
    }

    public void w(String tag, String msg, Throwable t) {
        this.write(LogLevel.WARN, tag, msg, t);
    }

    public void e(String msg) {
        this.e(this.tag, msg);
    }

    public void e(String tag, String msg) {
        this.e(tag, msg, null);
    }

    public void e(String msg, Throwable t) {
        this.e(this.tag, msg, t);
    }

    public void e(String tag, String msg, Throwable t) {
        this.write(LogLevel.ERROR, tag, msg, t);
    }

    protected abstract void write(LogLevel var1, String var2, String var3, Throwable var4);

    static String stackToString(Throwable t) {
        StringWriter sw = new StringWriter(128);
        PrintWriter ps = new PrintWriter(sw);
        t.printStackTrace(ps);
        ps.flush();
        return sw.toString();
    }

    @Override
    public void close() throws IOException {
    }
}

