/*
 * Decompiled with CFR 0.152.
 */
package wtf.s1.willfix;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import wtf.s1.willfix.WillFixContext;
import wtf.s1.willfix.WillFixVerify;
import wtf.s1.willfix.core.ILogger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0\nH\u0016J\u0010\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0\nH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lwtf/s1/willfix/WillFixTransform;", "Lcom/android/build/api/transform/Transform;", "context", "Lwtf/s1/willfix/WillFixContext;", "(Lwtf/s1/willfix/WillFixContext;)V", "getClassVisitor", "Lorg/objectweb/asm/ClassVisitor;", "cw", "Lorg/objectweb/asm/ClassWriter;", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getReferencedScopes", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getScopes", "isIncremental", "", "manipulate", "", "byteArray", "needManipulate", "fileName", "transform", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "Companion", "willfix-standalone"})
public class WillFixTransform
extends Transform {
    private final WillFixContext context;
    private static final String TRANSFORM_NAME = "willFix";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return TRANSFORM_NAME;
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return SetsKt.mutableSetOf((Object[])new QualifiedContent.ContentType[]{(QualifiedContent.ContentType)QualifiedContent.DefaultContentType.CLASSES});
    }

    public boolean isIncremental() {
        return false;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        return SetsKt.mutableSetOf((Object[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT, QualifiedContent.Scope.EXTERNAL_LIBRARIES, QualifiedContent.Scope.SUB_PROJECTS});
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return SetsKt.mutableSetOf((Object[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT, QualifiedContent.Scope.EXTERNAL_LIBRARIES, QualifiedContent.Scope.SUB_PROJECTS});
    }

    public void transform(@Nullable TransformInvocation transformInvocation) {
        super.transform(transformInvocation);
        this.context.init(transformInvocation);
        TransformInvocation transformInvocation2 = transformInvocation;
        if (transformInvocation2 != null) {
            TransformInvocation transformInvocation3 = transformInvocation2;
            boolean bl = false;
            boolean bl2 = false;
            TransformInvocation it = transformInvocation3;
            boolean bl3 = false;
            File contentLocation = it.getOutputProvider().getContentLocation(this.getName(), this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
            contentLocation.delete();
            contentLocation.mkdir();
            ILogger iLogger = this.context.logger();
            StringBuilder stringBuilder = new StringBuilder().append("content location ");
            File file = contentLocation;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"contentLocation");
            iLogger.d(stringBuilder.append(file.getAbsolutePath()).toString());
            Collection collection = it.getInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.inputs");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TransformInput input = (TransformInput)element$iv;
                boolean bl4 = false;
                TransformInput transformInput = input;
                Intrinsics.checkNotNullExpressionValue((Object)transformInput, (String)"input");
                Collection collection2 = transformInput.getDirectoryInputs();
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"input.directoryInputs");
                Iterable $this$forEach$iv2 = collection2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    DirectoryInput directoryInput = (DirectoryInput)element$iv2;
                    boolean bl5 = false;
                    DirectoryInput directoryInput2 = directoryInput;
                    Intrinsics.checkNotNullExpressionValue((Object)directoryInput2, (String)"directoryInput");
                    File file2 = directoryInput2.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"directoryInput.file");
                    String dirPath = file2.getAbsolutePath();
                    File file3 = directoryInput.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"directoryInput.file");
                    Sequence $this$forEach$iv3 = (Sequence)FilesKt.walkTopDown((File)file3);
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        String relativeFilePath;
                        String string;
                        File file4 = (File)element$iv3;
                        boolean bl6 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)file4.getAbsolutePath(), (String)"file.absolutePath");
                        int n = dirPath.length();
                        boolean bl7 = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                        this.context.logger().d("walk to down " + relativeFilePath);
                        if (!file4.isDirectory()) {
                            String fileName = file4.getName();
                            File outputFile = new File(contentLocation, relativeFilePath);
                            String string3 = fileName;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fileName");
                            if (this.needManipulate(string3)) {
                                FileInputStream fis = new FileInputStream(file4.getAbsolutePath());
                                FileOutputStream fos = new FileOutputStream(outputFile.getAbsolutePath());
                                fos.write(this.manipulate(ByteStreamsKt.readBytes((InputStream)fis)));
                                fos.close();
                                fis.close();
                                continue;
                            }
                            FilesKt.writeBytes((File)outputFile, (byte[])FilesKt.readBytes((File)file4));
                            continue;
                        }
                        File newDir = new File(contentLocation, relativeFilePath);
                        newDir.mkdir();
                        this.context.logger().d("new dir " + newDir.getAbsolutePath());
                    }
                }
                Collection collection3 = input.getJarInputs();
                Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"input.jarInputs");
                $this$forEach$iv2 = collection3;
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    JarInput jarInput = (JarInput)element$iv2;
                    boolean bl8 = false;
                    ILogger iLogger2 = this.context.logger();
                    StringBuilder stringBuilder2 = new StringBuilder().append("jarName = ");
                    JarInput jarInput2 = jarInput;
                    Intrinsics.checkNotNullExpressionValue((Object)jarInput2, (String)"jarInput");
                    iLogger2.d(stringBuilder2.append(jarInput2.getName()).toString());
                    String jarName = jarInput.getName();
                    File file5 = jarInput.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"jarInput.file");
                    String md5Name = DigestUtils.md5Hex((String)file5.getAbsolutePath());
                    String string = jarName;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarName");
                    if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
                        String $i$f$forEach3 = jarName;
                        int n = 0;
                        int element$iv3 = jarName.length() - 4;
                        boolean file4 = false;
                        String string4 = $i$f$forEach3.substring(n, element$iv3);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        jarName = string4;
                    }
                    File dest = it.getOutputProvider().getContentLocation(jarName + md5Name, jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                    JarFile jarFile = new JarFile(jarInput.getFile());
                    StringBuilder stringBuilder3 = new StringBuilder();
                    File file6 = jarInput.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file6, (String)"jarInput.file");
                    File tempFile = new File(stringBuilder3.append(file6.getParent()).append(File.separator).append("temp.jar").toString());
                    if (tempFile.exists()) {
                        tempFile.delete();
                    }
                    JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(tempFile));
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"jarFile.entries()");
                    Iterator $this$forEach$iv4 = CollectionsKt.iterator(enumeration);
                    boolean $i$f$forEach4 = false;
                    Iterator iterator = $this$forEach$iv4;
                    boolean bl9 = false;
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        byte[] byArray;
                        Object element$iv4 = iterator2.next();
                        JarEntry jarEntry = (JarEntry)element$iv4;
                        boolean bl10 = false;
                        InputStream entryInputStream = jarFile.getInputStream(jarEntry);
                        JarEntry jarEntry2 = jarEntry;
                        Intrinsics.checkNotNullExpressionValue((Object)jarEntry2, (String)"jarEntry");
                        ZipEntry nextZipEntry = new ZipEntry(jarEntry2.getName());
                        String string5 = "jarEntry name = " + jarEntry.getName();
                        boolean bl11 = false;
                        System.out.println((Object)string5);
                        jarOutputStream.putNextEntry(nextZipEntry);
                        String string6 = jarEntry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"jarEntry.name");
                        if (this.needManipulate(string6)) {
                            InputStream inputStream = entryInputStream;
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"entryInputStream");
                            byArray = this.manipulate(ByteStreamsKt.readBytes((InputStream)inputStream));
                        } else {
                            InputStream inputStream = entryInputStream;
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"entryInputStream");
                            byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
                        }
                        jarOutputStream.write(byArray);
                        jarOutputStream.closeEntry();
                    }
                    jarOutputStream.close();
                    jarFile.close();
                    FileUtils.copyFile((File)tempFile, (File)dest);
                    tempFile.delete();
                }
            }
        }
        this.context.logger().d("transform end");
    }

    private final boolean needManipulate(String fileName) {
        if (!this.context.isEnable()) {
            return false;
        }
        return StringsKt.endsWith$default((String)fileName, (String)".class", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)fileName, (String)"R.class", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)fileName, (String)"BuildConfig.class", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)fileName, (CharSequence)"R$", (boolean)false, (int)2, null);
    }

    private final byte[] manipulate(byte[] byteArray) {
        ClassReader classReader = new ClassReader(byteArray);
        ClassWriter classWriter = new ClassWriter(classReader, 1);
        classReader.accept(this.getClassVisitor(classWriter), 8);
        byte[] bytes = classWriter.toByteArray();
        if (this.context.needVerify()) {
            ClassNode verifyNode = new ClassNode();
            new ClassReader(bytes).accept((ClassVisitor)verifyNode, 8);
            WillFixVerify.Companion.verify(verifyNode);
        }
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        return bytes;
    }

    private final ClassVisitor getClassVisitor(ClassWriter cw) {
        return this.context.getClassVisitor(cw);
    }

    public WillFixTransform(@NotNull WillFixContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lwtf/s1/willfix/WillFixTransform$Companion;", "", "()V", "TRANSFORM_NAME", "", "willfix-standalone"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

