/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.tuples;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import wtf.g4s8.tuples.PairZip;
import wtf.g4s8.tuples.Triplet;
import wtf.g4s8.tuples.Tuple;
import wtf.g4s8.tuples.Unit;

public interface Pair<T, U> {
    public <R> R apply(BiFunction<? super T, ? super U, ? extends R> var1);

    default public void accept(BiConsumer<? super T, ? super U> consumer) {
        this.apply((first, second) -> {
            consumer.accept(first, second);
            return Tuple.None.VALUE;
        });
    }

    default public <V> Triplet<T, U, V> push(V val) {
        return this.apply((first, second) -> Triplet.of(first, second, val));
    }

    default public Unit<T> pop() {
        return this.apply((first, second) -> Unit.of(first));
    }

    public static <T, U> Pair<T, U> of(T first, U second) {
        return new Tuple.PairTuple<T, U>(first, second);
    }

    public static <T, U> Iterable<Pair<T, U>> zip(Iterable<? extends T> first, Iterable<? extends U> second) {
        return new PairZip<T, U>(first, second);
    }
}

