/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.hamcrest.json;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonValue;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class JsonContains
extends TypeSafeMatcher<JsonArray> {
    private final List<Matcher<? extends JsonValue>> matchers;

    @SafeVarargs
    public JsonContains(Matcher<? extends JsonValue> ... matchers) {
        this(Arrays.asList(matchers));
    }

    public JsonContains(List<Matcher<? extends JsonValue>> matchers) {
        this.matchers = Collections.unmodifiableList(matchers);
    }

    public void describeTo(Description description) {
        description.appendText(String.format("JSON array with %d items", this.matchers.size()));
    }

    protected boolean matchesSafely(JsonArray item) {
        boolean matches = true;
        if (item.size() == this.matchers.size()) {
            for (int pos = 0; pos < this.matchers.size(); ++pos) {
                if (this.matchers.get(pos).matches(item.get(pos))) continue;
                matches = false;
                break;
            }
        } else {
            matches = false;
        }
        return matches;
    }
}

