/*
 * Decompiled with CFR 0.152.
 */
package ws.suid;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Resource;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.sql.DataSource;
import ws.suid.Suid;

@Stateless
@LocalBean
public class SuidService {
    public static final int MAX_REQUEST_BLOCKS = 8;
    @Resource(name="jdbc/SuidRWDS")
    private DataSource db;

    public void init(int shard) {
        assert (shard >= 0 && shard <= 3) : "Parameter 'shard' is out of range (0..3): " + shard + ".";
        Connection con = null;
        Statement stm = null;
        try {
            con = this.db.getConnection();
            stm = con.createStatement();
            stm.execute("CREATE TABLE IF NOT EXISTS suid (\n\tblock BIGINT NOT NULL AUTO_INCREMENT,\n\tshard TINYINT NOT NULL,\n\tPRIMARY KEY (block),\n\tUNIQUE KEY shard (shard)\n)ENGINE = InnoDB;");
            ResultSet results = stm.executeQuery("SELECT block FROM suid");
            if (!results.first()) {
                stm.execute("INSERT INTO suid (shard) VALUES (" + shard + ");");
            }
            this.release(con, stm);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.release(con, stm);
                throw throwable;
            }
        }
    }

    public Suid[] nextBlocks(int count) {
        if (count < 1) {
            count = 1;
        }
        if (count > 8) {
            count = 8;
        }
        Suid[] results = new Suid[count];
        Connection con = null;
        Statement stm = null;
        try {
            con = this.db.getConnection();
            stm = con.createStatement();
            for (int i = 0; i < count; ++i) {
                results[i] = this.nextBlock(stm);
            }
            Suid[] i = results;
            this.release(con, stm);
            return i;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.release(con, stm);
                throw throwable;
            }
        }
    }

    private Suid nextBlock(Statement stm) throws SQLException {
        stm.execute("REPLACE INTO suid (shard) SELECT shard FROM suid;");
        ResultSet results = stm.executeQuery("SELECT LAST_INSERT_ID() AS block, shard FROM suid;");
        results.first();
        return Suid.valueOf(results.getLong("block"), 0, results.getByte("shard"));
    }

    private void release(Connection con, Statement stm) {
        if (stm != null) {
            try {
                stm.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            stm = null;
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            con = null;
        }
    }
}

