/*
 * Decompiled with CFR 0.152.
 */
package ws.suid;

public final class Suid
extends Number
implements CharSequence,
Comparable<Suid> {
    private static final long serialVersionUID = 1L;
    public static final long MASK_RESERVED = -9007199254740992L;
    public static final long MASK_BLOCK = 9007199254739968L;
    public static final long MASK_ID = 1020L;
    public static final long MASK_SHARD = 3L;
    public static final long MASK_TOKEN = 31L;
    public static final int COUNT_RESERVED = 11;
    public static final int COUNT_BLOCK = 43;
    public static final int COUNT_ID = 8;
    public static final int COUNT_SHARD = 2;
    public static final int OFFSET_BLOCK = 10;
    public static final int OFFSET_ID = 2;
    public static final String ALPHABET = "0123456789acdefghijkmnprstuvwxyz";
    public static final String[][] REPLACEMENT_SYMBOLS = new String[][]{{"b", "00"}, {"l", "01"}, {"o", "02"}, {"q", "03"}};
    private long value;
    private transient String strVal;

    private Suid(long value) {
        this.value = value;
    }

    public static Suid valueOf(long value) {
        return new Suid(value);
    }

    public static Suid valueOf(long block, int id, byte shard) {
        return new Suid(0x1FFFFFFFFFFFFFL & (0x1FFFFFFFFFFC00L & block << 10 | 0x3FCL & (long)(id << 2) | 3L & (long)shard));
    }

    public static Suid valueOf(String compressed) {
        if (compressed == null) {
            return null;
        }
        String base32 = Suid.decompress(compressed);
        return Suid.valueOfBase32(base32);
    }

    public static Suid valueOfBase32(String base32) {
        if (base32 == null) {
            return null;
        }
        long value = 0L;
        for (int i = base32.length() - 1; i >= 0; --i) {
            int idx = ALPHABET.indexOf(base32.charAt(i));
            if (idx == -1) {
                throw new IllegalArgumentException("Unable to parse input to a SUID: " + base32);
            }
            value = value * (long)ALPHABET.length() + (long)idx;
        }
        return new Suid(value);
    }

    @Override
    public String toString() {
        if (this.strVal == null) {
            this.strVal = Suid.compress(this.toBase32());
        }
        return this.strVal;
    }

    public String toBase32() {
        StringBuilder builder = new StringBuilder();
        for (int i = 10; i >= 0; --i) {
            int idx = (int)(this.value >> i * 5 & 0x1FL);
            if (idx <= 0 && builder.length() <= 0) continue;
            builder.append(ALPHABET.charAt(idx));
        }
        if (builder.length() == 0) {
            builder.append('0');
        }
        return builder.toString();
    }

    public static String compress(String base32) {
        String result = base32;
        for (String[] replacement : REPLACEMENT_SYMBOLS) {
            result = result.replace(replacement[1], replacement[0]);
        }
        return result;
    }

    public static String decompress(String compressed) {
        if (compressed == null) {
            return null;
        }
        String result = compressed;
        for (String[] replacement : REPLACEMENT_SYMBOLS) {
            result = result.replace(replacement[0], replacement[1]);
        }
        return result;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public long getBlock() {
        return (this.value & 0x1FFFFFFFFFFC00L) >> 10;
    }

    public byte getShard() {
        return (byte)(this.value & 3L);
    }

    public int getId() {
        return (int)(this.value & 0x3FCL);
    }

    public boolean isBlock() {
        return this.getId() == 0;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(Suid.class) && ((Suid)obj).value == this.value;
    }

    @Override
    public int compareTo(Suid obj) {
        return Long.compare(this.value, obj.value);
    }
}

