/*
 * Decompiled with CFR 0.152.
 */
package ws.suid;

import java.math.BigInteger;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.transaction.Transactional;
import ws.suid.Suid;

@Stateless
@LocalBean
public class SuidService {
    public static final int MAX_REQUEST_BLOCKS = 8;
    @PersistenceContext(unitName="SuidRWPU")
    private EntityManager em;

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public Suid[] nextBlocks(int count) {
        if (count < 1) {
            count = 1;
        }
        if (count > 8) {
            count = 8;
        }
        Suid[] results = new Suid[count];
        for (int i = 0; i < count; ++i) {
            results[i] = this.nextBlock();
        }
        return results;
    }

    public Suid next() {
        return Generator.get().next(this);
    }

    private Suid nextBlock() {
        Query query = this.em.createNativeQuery("REPLACE INTO suid (shard) SELECT shard FROM suid;");
        query.executeUpdate();
        query = this.em.createNativeQuery("SELECT LAST_INSERT_ID() AS block, shard FROM suid;");
        Object[] rs = (Object[])query.getSingleResult();
        Long block = ((BigInteger)rs[0]).longValue();
        Byte shard = (Byte)rs[1];
        return Suid.valueOf(block, 0, shard);
    }

    private static final class Generator {
        private static Generator instance;
        private Suid block;
        private int id;

        private Generator() {
        }

        public synchronized Suid next(SuidService suidService) {
            if (this.id >= 32) {
                this.id = 0;
                this.block = null;
            }
            if (this.block == null) {
                this.block = suidService.nextBlocks(1)[0];
            }
            return Suid.valueOf(this.block.getBlock(), this.id++, this.block.getShard());
        }

        public static final Generator get() {
            if (instance == null) {
                instance = new Generator();
            }
            return instance;
        }
    }
}

