/*
 * Decompiled with CFR 0.152.
 */
package ws.suid;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@JsonFormat(shape=JsonFormat.Shape.STRING)
@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public final class Suid
extends Number
implements CharSequence,
Comparable<Suid> {
    private static final long serialVersionUID = 1L;
    public static final Suid NULL = new Suid(0L);
    public static final String PREFIX = "Suid:";
    public static final int IDSIZE = 32;
    public static final int SHARDSIZE = 4;
    public static final long MASK_RESERVED = -9007199254740992L;
    public static final long MASK_BLOCK = 9007199254740864L;
    public static final long MASK_ID = 124L;
    public static final long MASK_SHARD = 3L;
    public static final int COUNT_RESERVED = 11;
    public static final int COUNT_BLOCK = 46;
    public static final int COUNT_ID = 5;
    public static final int COUNT_SHARD = 2;
    public static final int OFFSET_BLOCK = 7;
    public static final int OFFSET_ID = 2;
    public static final String ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz";
    private long value;
    private transient String strVal;

    protected Suid(String value) {
        this(value == null ? 0L : Suid.valueOf(value.startsWith(PREFIX) ? value.substring(PREFIX.length()) : value).longValue());
    }

    private Suid(long value) {
        this.value = value;
    }

    public static Suid valueOf(long value) {
        return value == NULL.longValue() ? NULL : new Suid(value);
    }

    public static Suid valueOf(long block, int id, byte shard) {
        return new Suid(0x1FFFFFFFFFFFFFL & (0x1FFFFFFFFFFF80L & block << 7 | 0x7CL & (long)(id << 2) | 3L & (long)shard));
    }

    public static Suid valueOf(String string) {
        if (string == null) {
            return null;
        }
        return Suid.valueOf(Long.parseLong(string, 36));
    }

    @Override
    public String toString() {
        if (this.strVal == null) {
            this.strVal = Long.toString(this.value, 36);
        }
        return this.strVal;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public Long toLong() {
        return this.value;
    }

    public long getBlock() {
        return (this.value & 0x1FFFFFFFFFFF80L) >> 7;
    }

    public byte getShard() {
        return (byte)(this.value & 3L);
    }

    public int getId() {
        return (int)(this.value & 0x7CL);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(Suid.class) && ((Suid)obj).value == this.value;
    }

    @Override
    public int compareTo(Suid obj) {
        return Long.compare(this.value, obj.value);
    }

    public String toJSON() {
        return PREFIX + this.toString();
    }

    public static boolean looksValid(String value) {
        if (value == null) {
            return false;
        }
        int len = value.length();
        if (len == 0 || len > 11) {
            return false;
        }
        if (len == 11 && ALPHABET.indexOf(value.charAt(0)) > 2) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (ALPHABET.indexOf(value.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean looksValidJSON(String json) {
        if (json == null || json.length() == 0) {
            return false;
        }
        if (!json.startsWith(PREFIX)) {
            return false;
        }
        return Suid.looksValid(json.substring(PREFIX.length()));
    }

    public static Suid valueOfJSON(String json) {
        if (!Suid.looksValidJSON(json)) {
            return null;
        }
        return Suid.valueOf(json.substring(PREFIX.length()));
    }

    public static List<Long> toLong(List<Suid> ids) {
        ArrayList<Long> results = new ArrayList<Long>();
        for (Suid id : ids) {
            results.add(id.toLong());
        }
        return results;
    }

    public static List<Suid> valueOf(List<Long> ids) {
        ArrayList<Suid> results = new ArrayList<Suid>();
        for (Long id : ids) {
            results.add(Suid.valueOf(id));
        }
        return results;
    }

    public static final class Deserializer
    extends StdDeserializer<Suid> {
        public Deserializer() {
            super(Suid.class);
        }

        public Suid deserialize(JsonParser parser, DeserializationContext ctx) throws IOException, JsonProcessingException {
            return Suid.valueOfJSON(parser.getValueAsString());
        }
    }

    public static final class Serializer
    extends StdSerializer<Suid> {
        public Serializer() {
            super(Suid.class);
        }

        public void serialize(Suid value, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonGenerationException {
            generator.writeString(value.toJSON());
        }
    }

    @Converter(autoApply=true)
    public static class SuidConverter
    implements AttributeConverter<Suid, Long> {
        public Long convertToDatabaseColumn(Suid suid) {
            return suid == null ? null : suid.toLong();
        }

        public Suid convertToEntityAttribute(Long suid) {
            return suid == null ? null : Suid.valueOf(suid);
        }
    }
}

