/*
 * Decompiled with CFR 0.152.
 */
package ws.suid;

import java.util.List;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import ws.suid.Suid;
import ws.suid.SuidRecord;

@Stateless
@LocalBean
public class SuidService {
    public static final int MAX_REQUEST_BLOCKS = 8;
    @PersistenceContext
    private EntityManager em;

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public Suid[] nextBlocks(int count) {
        if (count < 1) {
            count = 1;
        }
        if (count > 8) {
            count = 8;
        }
        TypedQuery query = this.em.createNamedQuery("suid_record_all", SuidRecord.class);
        query.setFirstResult(0).setMaxResults(1);
        List existing = query.getResultList();
        Byte shard = existing.isEmpty() ? Byte.valueOf((byte)0) : ((SuidRecord)existing.get(0)).getShard();
        Long block = existing.isEmpty() ? Long.valueOf(0L) : ((SuidRecord)existing.get(0)).getBlock();
        SuidRecord[] blocks = new SuidRecord[count];
        Suid[] results = new Suid[count];
        for (int i = 0; i < count; ++i) {
            if (!block.equals(0L)) {
                query = this.em.createNamedQuery("suid_record_del");
                query.setParameter("block", (Object)block);
                query.executeUpdate();
                this.em.flush();
            }
            blocks[i] = new SuidRecord(shard);
            this.em.persist((Object)blocks[i]);
            this.em.flush();
            this.em.refresh((Object)blocks[i]);
            block = blocks[i].getBlock();
            results[i] = new Suid(block, 0, shard);
        }
        return results;
    }

    public Suid next() {
        return Generator.get().next(this);
    }

    private static final class Generator {
        static Generator instance;
        Byte shard;
        Suid block;
        byte id;

        private Generator() {
        }

        public synchronized Suid next(SuidService suidService) {
            if ((long)this.id >= 64L) {
                this.id = 0;
                this.block = null;
            }
            if (this.block == null) {
                this.block = suidService.nextBlocks(1)[0];
                this.shard = this.block.getShard();
            }
            byte by = this.id;
            this.id = (byte)(by + 1);
            return new Suid(this.block.getBlock(), by, this.block.getShard());
        }

        public static final Generator get() {
            return instance == null ? (instance = new Generator()) : instance;
        }
    }
}

