/*
 * Decompiled with CFR 0.152.
 */
package ws.suid;

import java.util.List;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import ws.suid.Suid;
import ws.suid.SuidRecord;

@Stateless
@LocalBean
public class SuidService {
    public static final int MAX_REQUEST_BLOCKS = 8;
    @PersistenceContext
    private EntityManager em;

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public Suid[] nextBlocks(int count) {
        if (count < 1) {
            count = 1;
        }
        if (count > 8) {
            count = 8;
        }
        int genBlock = 0;
        Byte shard = Generator.get().shard;
        if (shard == null) {
            genBlock = 1;
            TypedQuery query = this.em.createNamedQuery("suid_record_all", SuidRecord.class);
            query.setFirstResult(0).setMaxResults(1);
            List existing = query.getResultList();
            shard = !existing.isEmpty() ? ((SuidRecord)existing.get(0)).getShard() : Byte.valueOf((byte)0);
        }
        SuidRecord[] blocks = new SuidRecord[count + genBlock];
        for (int i = 0; i < count + genBlock; ++i) {
            blocks[i] = new SuidRecord(shard);
            this.em.persist((Object)blocks[i]);
        }
        this.em.flush();
        Suid[] results = new Suid[count];
        for (int i = genBlock; i < count + genBlock; ++i) {
            this.em.refresh((Object)blocks[i]);
            results[i - genBlock] = new Suid(blocks[i].getBlock(), 0, shard);
        }
        if (genBlock == 1) {
            this.em.refresh((Object)blocks[0]);
            Generator.get().block = new Suid(blocks[0].getBlock(), 0, shard);
            Generator.get().shard = shard;
        }
        Query query = this.em.createNamedQuery("suid_record_del");
        query.setParameter("block", (Object)blocks[count + genBlock - 1].getBlock());
        query.executeUpdate();
        this.em.flush();
        return results;
    }

    public Suid next() {
        return Generator.get().next(this);
    }

    private static final class Generator {
        static Generator instance;
        Byte shard;
        Suid block;
        byte id;

        private Generator() {
        }

        public synchronized Suid next(SuidService suidService) {
            if ((long)this.id >= 64L) {
                this.id = 0;
                this.block = null;
            }
            if (this.block == null) {
                this.block = suidService.nextBlocks(1)[0];
                this.shard = this.block.getShard();
            }
            byte by = this.id;
            this.id = (byte)(by + 1);
            return new Suid(this.block.getBlock(), by, this.block.getShard());
        }

        public static final Generator get() {
            return instance == null ? (instance = new Generator()) : instance;
        }
    }
}

