/*
 * Decompiled with CFR 0.152.
 */
package ws.suid;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@JsonFormat(shape=JsonFormat.Shape.STRING)
@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public final class Suid
extends Number
implements CharSequence,
Comparable<Suid> {
    private static final long serialVersionUID = 1L;
    public static final String ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz";
    public static final long MASK_RESERVED = -4503599627370496L;
    public static final long MASK_BLOCK = 0xFFFFFFFFFFFF0L;
    public static final long MASK_GEN = 15L;
    public static final byte COUNT_RESERVED = 12;
    public static final byte COUNT_BLOCK = 48;
    public static final byte COUNT_GEN = 4;
    public static final byte OFFSET_RESERVED = 52;
    public static final byte OFFSET_BLOCK = 4;
    public static final byte OFFSET_GEN = 0;
    public static final long BLOCK_SIZE = 0x1000000000000L;
    public static final long GEN_SIZE = 16L;
    private long value;
    private transient String strVal;

    public Suid(String value) throws NumberFormatException {
        this(value == null ? 0L : Long.parseLong(value, 36));
    }

    public Suid(long value) {
        this.value = value;
    }

    public Suid(long block, byte id) {
        this.value = 0xFFFFFFFFFFFFFL & (0xFFFFFFFFFFFF0L & block << 4 | 0xFL & (long)(id << 0));
    }

    @Override
    public String toString() {
        if (this.strVal == null) {
            this.strVal = Long.toString(this.value, 36);
        }
        return this.strVal;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public Long toLong() {
        return this.value;
    }

    public long getBlock() {
        return (this.value & 0xFFFFFFFFFFFF0L) >> 4;
    }

    public byte getBits() {
        return (byte)((this.value & 0xFL) >> 0);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object that) {
        return that != null && that.getClass().equals(Suid.class) && ((Suid)that).value == this.value;
    }

    @Override
    public int compareTo(Suid that) throws NullPointerException {
        return Long.compare(this.value, that.value);
    }

    public static boolean looksValid(String value) {
        if (value == null) {
            return false;
        }
        int len = value.length();
        if (len == 0 || len > 11) {
            return false;
        }
        if (len == 11 && ALPHABET.indexOf(value.charAt(0)) > 2) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (ALPHABET.indexOf(value.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static List<Long> toLong(List<Suid> ids) {
        ArrayList<Long> results = new ArrayList<Long>();
        for (Suid id : ids) {
            results.add(id.toLong());
        }
        return results;
    }

    public static List<String> toString(List<Suid> ids) {
        ArrayList<String> results = new ArrayList<String>();
        for (Suid id : ids) {
            results.add(id.toString());
        }
        return results;
    }

    public static List<Suid> fromLong(List<Long> ids) {
        ArrayList<Suid> results = new ArrayList<Suid>();
        for (Long id : ids) {
            results.add(new Suid(id));
        }
        return results;
    }

    public static List<Suid> fromString(List<String> ids) {
        ArrayList<Suid> results = new ArrayList<Suid>();
        for (String id : ids) {
            results.add(new Suid(id));
        }
        return results;
    }

    public static Suid valueOf(String id) {
        return id == null ? null : new Suid(id);
    }

    public static Suid valueOf(Long id) {
        return id == null ? null : new Suid(id);
    }

    public static final class Deserializer
    extends StdDeserializer<Suid> {
        public Deserializer() {
            super(Suid.class);
        }

        public Suid deserialize(JsonParser parser, DeserializationContext ctx) throws IOException, JsonProcessingException {
            return new Suid(parser.getValueAsString());
        }
    }

    public static final class Serializer
    extends StdSerializer<Suid> {
        public Serializer() {
            super(Suid.class);
        }

        public void serialize(Suid value, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonGenerationException {
            generator.writeString(value.toString());
        }
    }

    @Converter(autoApply=true)
    public static class SuidConverter
    implements AttributeConverter<Suid, Long> {
        public Long convertToDatabaseColumn(Suid suid) {
            return suid == null ? null : suid.toLong();
        }

        public Suid convertToEntityAttribute(Long suid) {
            return suid == null ? null : new Suid(suid);
        }
    }
}

