/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.maven;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.osiris.aws.ApiFactory;
import ws.osiris.aws.ConfigKt;
import ws.osiris.awsdeploy.DeployableProject;
import ws.osiris.maven.MavenKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\fR\u0014\u0010\u001f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\fR\u0014\u0010!\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0010\u00a8\u0006#"}, d2={"Lws/osiris/maven/MavenDeployableProject;", "Lws/osiris/awsdeploy/DeployableProject;", "rootPackage", "", "environmentName", "staticFilesDirectory", "awsProfile", "stackName", "project", "Lorg/apache/maven/project/MavenProject;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/apache/maven/project/MavenProject;)V", "getAwsProfile", "()Ljava/lang/String;", "buildDir", "Ljava/nio/file/Path;", "getBuildDir", "()Ljava/nio/file/Path;", "getEnvironmentName", "name", "getName", "projectJar", "getProjectJar", "getRootPackage", "runtimeClasspath", "", "getRuntimeClasspath", "()Ljava/util/List;", "sourceDir", "getSourceDir", "getStackName", "getStaticFilesDirectory", "version", "getVersion", "zipBuildDir", "getZipBuildDir", "osiris-maven-plugin"})
public final class MavenDeployableProject
implements DeployableProject {
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    @NotNull
    private final Path buildDir;
    @NotNull
    private final Path zipBuildDir;
    @NotNull
    private final Path sourceDir;
    @NotNull
    private final String rootPackage;
    @Nullable
    private final String environmentName;
    @Nullable
    private final String staticFilesDirectory;
    @Nullable
    private final String awsProfile;
    @Nullable
    private final String stackName;
    private final MavenProject project;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public Path getBuildDir() {
        return this.buildDir;
    }

    @NotNull
    public Path getZipBuildDir() {
        return this.zipBuildDir;
    }

    @NotNull
    public Path getSourceDir() {
        return this.sourceDir;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Path> getRuntimeClasspath() {
        void $this$mapTo$iv$iv;
        Set set = this.project.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"project.artifacts");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.apache.maven.artifact.Artifact");
            }
            Path path = ((Artifact)v1).getFile().toPath();
            collection.add(path);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Path getProjectJar() {
        Artifact artifact = this.project.getArtifact();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifact, (String)"project.artifact");
        if (artifact.getFile() == null) {
            Path path = this.getBuildDir();
            StringBuilder stringBuilder = new StringBuilder();
            Artifact artifact2 = this.project.getArtifact();
            Intrinsics.checkExpressionValueIsNotNull((Object)artifact2, (String)"project.artifact");
            StringBuilder stringBuilder2 = stringBuilder.append(artifact2.getArtifactId()).append("-");
            Artifact artifact3 = this.project.getArtifact();
            Intrinsics.checkExpressionValueIsNotNull((Object)artifact3, (String)"project.artifact");
            Path jarPath = path.resolve(stringBuilder2.append(artifact3.getVersion()).append(".jar").toString());
            if (Files.exists(jarPath, new LinkOption[0])) {
                MavenKt.access$getLog$p().debug("project.artifact.file == null, path {} exists", (Object)jarPath.toAbsolutePath());
                Path path2 = jarPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"jarPath");
                return path2;
            }
            MavenKt.access$getLog$p().debug("project.artifact.file == null, path {} does not exist", (Object)jarPath.toAbsolutePath());
            throw (Throwable)new FileNotFoundException("Project jar not found, run mvn package");
        }
        Artifact artifact4 = this.project.getArtifact();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifact4, (String)"project.artifact");
        Path path = artifact4.getFile().toPath();
        MavenKt.access$getLog$p().debug("project.artifact.file != null, exists = {}", (Object)Files.exists(path, new LinkOption[0]));
        Path path3 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"path");
        return path3;
    }

    @NotNull
    public String getRootPackage() {
        return this.rootPackage;
    }

    @Nullable
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Nullable
    public String getStaticFilesDirectory() {
        return this.staticFilesDirectory;
    }

    @Nullable
    public String getAwsProfile() {
        return this.awsProfile;
    }

    @Nullable
    public String getStackName() {
        return this.stackName;
    }

    public MavenDeployableProject(@NotNull String rootPackage, @Nullable String environmentName, @Nullable String staticFilesDirectory, @Nullable String awsProfile, @Nullable String stackName, @NotNull MavenProject project) {
        Intrinsics.checkParameterIsNotNull((Object)rootPackage, (String)"rootPackage");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.rootPackage = rootPackage;
        this.environmentName = environmentName;
        this.staticFilesDirectory = staticFilesDirectory;
        this.awsProfile = awsProfile;
        this.stackName = stackName;
        this.project = project;
        String string = this.project.getArtifactId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.artifactId");
        this.name = string;
        String string2 = this.project.getVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.version");
        this.version = string2;
        Build build = this.project.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)build, (String)"project.build");
        Path path = Paths.get(build.getDirectory(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(project.build.directory)");
        this.buildDir = path;
        this.zipBuildDir = this.getBuildDir();
        Build build2 = this.project.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)build2, (String)"project.build");
        Path path2 = Paths.get(build2.getSourceDirectory(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(project.build.sourceDirectory)");
        Path path3 = path2.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(project.build.sourceDirectory).parent");
        this.sourceDir = path3;
        ConfigKt.validateName((String)this.getEnvironmentName());
        ConfigKt.validateName((String)this.getStackName());
    }

    @NotNull
    public ApiFactory<?> createApiFactory(@NotNull ClassLoader parentClassLoader) {
        Intrinsics.checkParameterIsNotNull((Object)parentClassLoader, (String)"parentClassLoader");
        return DeployableProject.DefaultImpls.createApiFactory((DeployableProject)this, (ClassLoader)parentClassLoader);
    }

    @NotNull
    public Map<String, String> deploy() {
        return DeployableProject.DefaultImpls.deploy((DeployableProject)this);
    }

    public void generateCloudFormation() {
        DeployableProject.DefaultImpls.generateCloudFormation((DeployableProject)this);
    }

    public void openBrowser(@NotNull String stage, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)stage, (String)"stage");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DeployableProject.DefaultImpls.openBrowser((DeployableProject)this, (String)stage, (String)path);
    }
}

