/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.maven;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.osiris.aws.ApiFactory;
import ws.osiris.awsdeploy.DeployableProject;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0014\u0010\u0017\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0014\u0010\u001b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\f\u00a8\u0006\u001d"}, d2={"Lws/osiris/maven/MavenDeployableProject;", "Lws/osiris/awsdeploy/DeployableProject;", "rootPackage", "", "environmentName", "staticFilesDirectory", "awsProfile", "stackName", "project", "Lorg/apache/maven/project/MavenProject;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/apache/maven/project/MavenProject;)V", "getAwsProfile", "()Ljava/lang/String;", "buildDir", "Ljava/nio/file/Path;", "getBuildDir", "()Ljava/nio/file/Path;", "getEnvironmentName", "jarBuildDir", "getJarBuildDir", "name", "getName", "getRootPackage", "sourceDir", "getSourceDir", "getStackName", "getStaticFilesDirectory", "version", "getVersion", "osiris-maven-plugin"})
public final class MavenDeployableProject
implements DeployableProject {
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    @NotNull
    private final Path buildDir;
    @NotNull
    private final Path jarBuildDir;
    @NotNull
    private final Path sourceDir;
    @NotNull
    private final String rootPackage;
    @Nullable
    private final String environmentName;
    @Nullable
    private final String staticFilesDirectory;
    @Nullable
    private final String awsProfile;
    @Nullable
    private final String stackName;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public Path getBuildDir() {
        return this.buildDir;
    }

    @NotNull
    public Path getJarBuildDir() {
        return this.jarBuildDir;
    }

    @NotNull
    public Path getSourceDir() {
        return this.sourceDir;
    }

    @NotNull
    public String getRootPackage() {
        return this.rootPackage;
    }

    @Nullable
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Nullable
    public String getStaticFilesDirectory() {
        return this.staticFilesDirectory;
    }

    @Nullable
    public String getAwsProfile() {
        return this.awsProfile;
    }

    @Nullable
    public String getStackName() {
        return this.stackName;
    }

    public MavenDeployableProject(@NotNull String rootPackage, @Nullable String environmentName, @Nullable String staticFilesDirectory, @Nullable String awsProfile, @Nullable String stackName, @NotNull MavenProject project) {
        Intrinsics.checkParameterIsNotNull((Object)rootPackage, (String)"rootPackage");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.rootPackage = rootPackage;
        this.environmentName = environmentName;
        this.staticFilesDirectory = staticFilesDirectory;
        this.awsProfile = awsProfile;
        this.stackName = stackName;
        String string = project.getArtifactId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.artifactId");
        this.name = string;
        String string2 = project.getVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.version");
        this.version = string2;
        Build build = project.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)build, (String)"project.build");
        Path path = Paths.get(build.getDirectory(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(project.build.directory)");
        this.buildDir = path;
        this.jarBuildDir = this.getBuildDir();
        Build build2 = project.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)build2, (String)"project.build");
        Path path2 = Paths.get(build2.getSourceDirectory(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(project.build.sourceDirectory)");
        Path path3 = path2.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(project.build.sourceDirectory).parent");
        this.sourceDir = path3;
    }

    @NotNull
    public ApiFactory<?> createApiFactory(@NotNull ClassLoader parentClassLoader) {
        Intrinsics.checkParameterIsNotNull((Object)parentClassLoader, (String)"parentClassLoader");
        return DeployableProject.DefaultImpls.createApiFactory((DeployableProject)this, (ClassLoader)parentClassLoader);
    }

    @NotNull
    public Map<String, String> deploy() {
        return DeployableProject.DefaultImpls.deploy((DeployableProject)this);
    }

    public void generateCloudFormation() {
        DeployableProject.DefaultImpls.generateCloudFormation((DeployableProject)this);
    }

    @NotNull
    public Path generatedTemplatePath(@NotNull String appName) {
        Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
        return DeployableProject.DefaultImpls.generatedTemplatePath((DeployableProject)this, (String)appName);
    }
}

