/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.localserver;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import ws.osiris.core.Api;
import ws.osiris.core.ComponentsProvider;
import ws.osiris.core.ContentType;
import ws.osiris.core.Headers;
import ws.osiris.core.HttpMethod;
import ws.osiris.core.ModelKt;
import ws.osiris.core.Params;
import ws.osiris.core.Request;
import ws.osiris.core.RequestContextFactory;
import ws.osiris.core.Response;
import ws.osiris.core.RouteMatch;
import ws.osiris.core.RouteNode;
import ws.osiris.localserver.LocalServerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0014\u0010\u001b\u001a\u00020\u0007*\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lws/osiris/localserver/OsirisServlet;", "T", "Lws/osiris/core/ComponentsProvider;", "Ljakarta/servlet/http/HttpServlet;", "()V", "binaryMimeTypes", "", "", "components", "Lws/osiris/core/ComponentsProvider;", "requestContextFactory", "Lws/osiris/core/RequestContextFactory;", "routeTree", "Lws/osiris/core/RouteNode;", "init", "", "config", "Ljakarta/servlet/ServletConfig;", "requestBody", "", "headers", "", "req", "Ljakarta/servlet/http/HttpServletRequest;", "service", "resp", "Ljakarta/servlet/http/HttpServletResponse;", "initParam", "name", "Companion", "osiris-local-server"})
@SourceDebugExtension(value={"SMAP\nLocalServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalServer.kt\nws/osiris/localserver/OsirisServlet\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n759#2,2:209\n775#2,4:211\n1#3:215\n*S KotlinDebug\n*F\n+ 1 LocalServer.kt\nws/osiris/localserver/OsirisServlet\n*L\n62#1:209,2\n62#1:211,4\n*E\n"})
public final class OsirisServlet<T extends ComponentsProvider>
extends HttpServlet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private RouteNode<T> routeTree;
    private T components;
    private RequestContextFactory requestContextFactory;
    private Set<String> binaryMimeTypes;
    @NotNull
    public static final String API_ATTRIBUTE = "api";
    @NotNull
    public static final String COMPONENTS_ATTRIBUTE = "components";
    @NotNull
    public static final String REQUEST_CONTEXT_FACTORY_ATTRIBUTE = "requestContextFactory";

    public void init(@NotNull ServletConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Api api = (Api)config.getServletContext().getAttribute(API_ATTRIBUTE);
        if (api == null) {
            throw new IllegalStateException("The Api instance must be a servlet context attribute keyed with api");
        }
        Api providedApi = api;
        Object providedComponents = config.getServletContext().getAttribute(COMPONENTS_ATTRIBUTE);
        Object contextFactory = config.getServletContext().getAttribute(REQUEST_CONTEXT_FACTORY_ATTRIBUTE);
        this.routeTree = RouteNode.Companion.create(providedApi);
        Intrinsics.checkNotNull((Object)providedComponents, (String)"null cannot be cast to non-null type T of ws.osiris.localserver.OsirisServlet");
        this.components = (ComponentsProvider)providedComponents;
        Intrinsics.checkNotNull((Object)contextFactory, (String)"null cannot be cast to non-null type ws.osiris.core.RequestContextFactory");
        this.requestContextFactory = (RequestContextFactory)contextFactory;
        this.binaryMimeTypes = providedApi.getBinaryMimeTypes();
    }

    /*
     * WARNING - void declaration
     */
    protected void service(@NotNull HttpServletRequest req, @NotNull HttpServletResponse resp) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)resp, (String)"resp");
        String string = req.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethod(...)");
        HttpMethod method = HttpMethod.valueOf((String)string);
        String path = req.getPathInfo();
        Params queryParams = Params.Companion.fromQueryString(req.getQueryString());
        RouteNode<T> routeNode = this.routeTree;
        if (routeNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"routeTree");
            routeNode = null;
        }
        Intrinsics.checkNotNull((Object)path);
        RouteMatch match = ModelKt.match(routeNode, (HttpMethod)method, (String)path);
        if (match == null) {
            LocalServerKt.access$write(resp, 404, new Headers(null, 1, null), null);
            return;
        }
        Enumeration enumeration = req.getHeaderNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getHeaderNames(...)");
        Sequence $this$associateWith$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration));
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string2 = (String)element$iv$iv;
            Object e = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            String string3 = req.getHeader((String)it);
            map.put(e, string3);
        }
        Map headerMap = result$iv;
        Params headers = new Params(headerMap);
        Params pathParams = new Params(match.getVars());
        Object body = this.requestBody(headerMap, req);
        RequestContextFactory requestContextFactory = this.requestContextFactory;
        if (requestContextFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)REQUEST_CONTEXT_FACTORY_ATTRIBUTE);
            requestContextFactory = null;
        }
        Params context = requestContextFactory.createContext(method, path, headers, queryParams, pathParams, body);
        Request request = new Request(method, path, headers, queryParams, pathParams, context, body, null, null, 384, null);
        Function2 function2 = match.getHandler();
        T t = this.components;
        if (t == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)COMPONENTS_ATTRIBUTE);
            t = null;
        }
        Response response = (Response)function2.invoke(t, (Object)request);
        LocalServerKt.access$write(resp, response.getStatus(), response.getHeaders(), response.getBody());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object requestBody(Map<String, String> headers, HttpServletRequest req) {
        Serializable serializable;
        String string = headers.get("Content-Type");
        if (string == null) {
            return LocalServerKt.access$bodyAsString(req);
        }
        String contentType = string;
        String mimeType = ContentType.Companion.parse(contentType).component1();
        Set<String> set = this.binaryMimeTypes;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binaryMimeTypes");
            set = null;
        }
        if (set.contains(mimeType)) {
            byte[] byArray;
            Closeable closeable = (Closeable)req.getInputStream();
            Throwable throwable = null;
            try {
                ServletInputStream it = (ServletInputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                byArray = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            serializable = (Serializable)byArray;
        } else {
            serializable = (Serializable)((Object)LocalServerKt.access$bodyAsString(req));
        }
        return serializable;
    }

    private final String initParam(ServletConfig $this$initParam, String name) {
        String string = $this$initParam.getInitParameter(name);
        if (string == null) {
            throw new IllegalArgumentException("Missing init param " + name);
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lws/osiris/localserver/OsirisServlet$Companion;", "", "()V", "API_ATTRIBUTE", "", "COMPONENTS_ATTRIBUTE", "REQUEST_CONTEXT_FACTORY_ATTRIBUTE", "osiris-local-server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

