/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.localserver;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.osiris.core.Api;
import ws.osiris.core.ComponentsProvider;
import ws.osiris.core.Headers;
import ws.osiris.core.RequestContextFactory;
import ws.osiris.core.StaticRoute;
import ws.osiris.localserver.OsirisServlet;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u001a.\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u001aW\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00062\u0006\u0010\u0010\u001a\u0002H\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\u0010\u0015\u001aU\u0010\u0016\u001a\u00020\u0017\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00062\u0006\u0010\u0010\u001a\u0002H\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0018\u001a\f\u0010\u0019\u001a\u00020\n*\u00020\u001aH\u0002\u001a&\u0010\u001b\u001a\u00020\u0017*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "configureStaticFiles", "Lorg/eclipse/jetty/server/Handler;", "api", "Lws/osiris/core/Api;", "servletHandler", "Lorg/eclipse/jetty/servlet/ServletContextHandler;", "contextRoot", "", "staticFilesDir", "createLocalServer", "Lorg/eclipse/jetty/server/Server;", "T", "Lws/osiris/core/ComponentsProvider;", "components", "port", "", "requestContextFactory", "Lws/osiris/core/RequestContextFactory;", "(Lws/osiris/core/Api;Lws/osiris/core/ComponentsProvider;ILjava/lang/String;Ljava/lang/String;Lws/osiris/core/RequestContextFactory;)Lorg/eclipse/jetty/server/Server;", "runLocalServer", "", "(Lws/osiris/core/Api;Lws/osiris/core/ComponentsProvider;ILjava/lang/String;Ljava/lang/String;Lws/osiris/core/RequestContextFactory;)V", "bodyAsString", "Ljakarta/servlet/http/HttpServletRequest;", "write", "Ljakarta/servlet/http/HttpServletResponse;", "httpStatus", "headers", "Lws/osiris/core/Headers;", "body", "", "osiris-local-server"})
@SourceDebugExtension(value={"SMAP\nLocalServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalServer.kt\nws/osiris/localserver/LocalServerKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n215#2,2:209\n1#3:211\n*S KotlinDebug\n*F\n+ 1 LocalServer.kt\nws/osiris/localserver/LocalServerKt\n*L\n103#1:209,2\n*E\n"})
public final class LocalServerKt {
    private static final Logger log = LoggerFactory.getLogger((String)"ws.osiris.localserver");

    private static final String bodyAsString(HttpServletRequest $this$bodyAsString) {
        InputStream inputStream = (InputStream)$this$bodyAsString.getInputStream();
        String string = $this$bodyAsString.getCharacterEncoding();
        if (string == null) {
            string = "UTF-8";
        }
        String string2 = new BufferedReader(new InputStreamReader(inputStream, string)).lines().collect(Collectors.joining("\n"));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"collect(...)");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void write(HttpServletResponse $this$write, int httpStatus, Headers headers, Object body) {
        Object it;
        $this$write.setStatus(httpStatus);
        Map $this$forEach$iv = headers.getHeaderMap();
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = object.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            $this$write.addHeader(name, value);
        }
        Object object2 = body;
        if (object2 instanceof String) {
            ServletOutputStream servletOutputStream = $this$write.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)servletOutputStream, (String)"getOutputStream(...)");
            Closeable closeable = (OutputStream)servletOutputStream;
            object = Charsets.UTF_8;
            closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
            object = null;
            try {
                it = (OutputStreamWriter)closeable;
                boolean bl = false;
                ((Writer)it).write((String)body);
                it = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                object = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        } else if (object2 instanceof byte[]) {
            Closeable closeable = (Closeable)$this$write.getOutputStream();
            object = null;
            try {
                it = (ServletOutputStream)closeable;
                boolean bl = false;
                it.write((byte[])body);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        } else {
            if (object2 == null) {
                return;
            }
            throw new IllegalArgumentException("Unexpected body type " + body.getClass().getName() + ", need String or ByteArray");
        }
    }

    public static final <T extends ComponentsProvider> void runLocalServer(@NotNull Api<T> api, @NotNull T components, int port, @NotNull String contextRoot, @Nullable String staticFilesDir, @NotNull RequestContextFactory requestContextFactory) {
        Intrinsics.checkNotNullParameter(api, (String)"api");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)contextRoot, (String)"contextRoot");
        Intrinsics.checkNotNullParameter((Object)requestContextFactory, (String)"requestContextFactory");
        Server server = LocalServerKt.createLocalServer(api, components, port, contextRoot, staticFilesDir, requestContextFactory);
        server.start();
        log.info("Server started at http://localhost:{}{}/", (Object)port, (Object)contextRoot);
        server.join();
    }

    public static /* synthetic */ void runLocalServer$default(Api api, ComponentsProvider componentsProvider, int n, String string, String string2, RequestContextFactory requestContextFactory, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 8080;
        }
        if ((n2 & 8) != 0) {
            string = "";
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        if ((n2 & 0x20) != 0) {
            requestContextFactory = RequestContextFactory.Companion.empty();
        }
        LocalServerKt.runLocalServer(api, componentsProvider, n, string, string2, requestContextFactory);
    }

    @NotNull
    public static final <T extends ComponentsProvider> Server createLocalServer(@NotNull Api<T> api, @NotNull T components, int port, @NotNull String contextRoot, @Nullable String staticFilesDir, @NotNull RequestContextFactory requestContextFactory) {
        Intrinsics.checkNotNullParameter(api, (String)"api");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)contextRoot, (String)"contextRoot");
        Intrinsics.checkNotNullParameter((Object)requestContextFactory, (String)"requestContextFactory");
        Server server = new Server(port);
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath("/");
        servletContextHandler.addServlet(OsirisServlet.class, contextRoot + "/*");
        servletContextHandler.setAttribute("api", api);
        servletContextHandler.setAttribute("components", components);
        servletContextHandler.setAttribute("requestContextFactory", (Object)requestContextFactory);
        server.setHandler(LocalServerKt.configureStaticFiles(api, servletContextHandler, contextRoot, staticFilesDir));
        return server;
    }

    public static /* synthetic */ Server createLocalServer$default(Api api, ComponentsProvider componentsProvider, int n, String string, String string2, RequestContextFactory requestContextFactory, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 8080;
        }
        if ((n2 & 8) != 0) {
            string = "";
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        if ((n2 & 0x20) != 0) {
            requestContextFactory = RequestContextFactory.Companion.empty();
        }
        return LocalServerKt.createLocalServer(api, componentsProvider, n, string, string2, requestContextFactory);
    }

    private static final Handler configureStaticFiles(Api<?> api, ServletContextHandler servletHandler, String contextRoot, String staticFilesDir) {
        Handler handler;
        List staticRoutes = CollectionsKt.filterIsInstance((Iterable)api.getRoutes(), StaticRoute.class);
        if (staticRoutes.size() > 1) {
            throw new IllegalArgumentException("Only one static file path is supported");
        }
        if (api.getStaticFiles()) {
            if (staticFilesDir == null) {
                throw new IllegalArgumentException("No static file location specified");
            }
            ResourceHandler resourceHandler = new ResourceHandler();
            StaticRoute staticRoute = (StaticRoute)staticRoutes.get(0);
            String string = staticRoute.getIndexFile();
            if (string != null) {
                String it = string;
                boolean bl = false;
                String[] stringArray = new String[]{it};
                resourceHandler.setWelcomeFiles(stringArray);
            }
            resourceHandler.setResourceBase(staticFilesDir);
            ContextHandler contextHandler = new ContextHandler(contextRoot + staticRoute.getPath());
            contextHandler.setHandler((Handler)resourceHandler);
            log.info("Serving static files from {}", (Object)Paths.get(staticFilesDir, new String[0]).normalize().toAbsolutePath());
            Handler[] handlerArray = new Handler[]{contextHandler, servletHandler};
            handler = (Handler)new HandlerList(handlerArray);
        } else {
            log.debug("API does not contain static files, skipping static files configuration");
            handler = (Handler)servletHandler;
        }
        return handler;
    }

    public static final /* synthetic */ void access$write(HttpServletResponse $receiver, int httpStatus, Headers headers, Object body) {
        LocalServerKt.write($receiver, httpStatus, headers, body);
    }

    public static final /* synthetic */ String access$bodyAsString(HttpServletRequest $receiver) {
        return LocalServerKt.bodyAsString($receiver);
    }
}

