/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.localserver;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import ws.osiris.core.Api;
import ws.osiris.core.ComponentsProvider;
import ws.osiris.core.ContentType;
import ws.osiris.core.Headers;
import ws.osiris.core.HttpMethod;
import ws.osiris.core.ModelKt;
import ws.osiris.core.Params;
import ws.osiris.core.Request;
import ws.osiris.core.RequestContextFactory;
import ws.osiris.core.Response;
import ws.osiris.core.RouteMatch;
import ws.osiris.core.RouteNode;
import ws.osiris.localserver.LocalServerKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0014\u0010\u001b\u001a\u00020\u0007*\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lws/osiris/localserver/OsirisServlet;", "T", "Lws/osiris/core/ComponentsProvider;", "Ljavax/servlet/http/HttpServlet;", "()V", "binaryMimeTypes", "", "", "components", "Lws/osiris/core/ComponentsProvider;", "requestContextFactory", "Lws/osiris/core/RequestContextFactory;", "routeTree", "Lws/osiris/core/RouteNode;", "init", "", "config", "Ljavax/servlet/ServletConfig;", "requestBody", "", "headers", "", "req", "Ljavax/servlet/http/HttpServletRequest;", "service", "resp", "Ljavax/servlet/http/HttpServletResponse;", "initParam", "name", "Companion", "osiris-local-server"})
public final class OsirisServlet<T extends ComponentsProvider>
extends HttpServlet {
    private RouteNode<T> routeTree;
    private T components;
    private RequestContextFactory requestContextFactory;
    private Set<String> binaryMimeTypes;
    @NotNull
    public static final String API_ATTRIBUTE = "api";
    @NotNull
    public static final String COMPONENTS_ATTRIBUTE = "components";
    @NotNull
    public static final String REQUEST_CONTEXT_FACTORY_ATTRIBUTE = "requestContextFactory";
    public static final Companion Companion = new Companion(null);

    public void init(@NotNull ServletConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Api api = (Api)config.getServletContext().getAttribute(API_ATTRIBUTE);
        if (api == null) {
            throw (Throwable)new IllegalStateException("The Api instance must be a servlet context attribute keyed with api");
        }
        Api providedApi = api;
        Object providedComponents = config.getServletContext().getAttribute(COMPONENTS_ATTRIBUTE);
        Object contextFactory = config.getServletContext().getAttribute(REQUEST_CONTEXT_FACTORY_ATTRIBUTE);
        this.routeTree = RouteNode.Companion.create(providedApi);
        Object object = providedComponents;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        this.components = (ComponentsProvider)object;
        Object object2 = contextFactory;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type ws.osiris.core.RequestContextFactory");
        }
        this.requestContextFactory = (RequestContextFactory)object2;
        this.binaryMimeTypes = providedApi.getBinaryMimeTypes();
    }

    /*
     * WARNING - void declaration
     */
    protected void service(@NotNull HttpServletRequest req, @NotNull HttpServletResponse resp) {
        Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
        Intrinsics.checkParameterIsNotNull((Object)resp, (String)"resp");
        String string = req.getMethod();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"req.method");
        HttpMethod method = HttpMethod.valueOf((String)string);
        String path = req.getPathInfo();
        Params queryParams = Params.Companion.fromQueryString(req.getQueryString());
        RouteNode<T> routeNode = this.routeTree;
        if (routeNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"routeTree");
        }
        String string2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        RouteMatch match = ModelKt.match(routeNode, (HttpMethod)method, (String)string2);
        if (match == null) {
            LocalServerKt.access$write(resp, 404, new Headers(null, 1, null), null);
            return;
        }
        Enumeration enumeration = req.getHeaderNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)enumeration, (String)"req.headerNames");
        Sequence $this$associateWith$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration));
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string3 = (String)element$iv$iv;
            Object e = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            String string4 = req.getHeader((String)it);
            map.put(e, string4);
        }
        Map headerMap = result$iv;
        Params headers = new Params(headerMap);
        Params pathParams = new Params(match.getVars());
        Object body = this.requestBody(headerMap, req);
        RequestContextFactory requestContextFactory = this.requestContextFactory;
        if (requestContextFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)REQUEST_CONTEXT_FACTORY_ATTRIBUTE);
        }
        Params context = requestContextFactory.createContext(method, path, headers, queryParams, pathParams, body);
        Request request = new Request(method, path, headers, queryParams, pathParams, context, body, null, null, 384, null);
        Function2 function2 = match.getHandler();
        T t = this.components;
        if (t == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)COMPONENTS_ATTRIBUTE);
        }
        Response response = (Response)function2.invoke(t, (Object)request);
        LocalServerKt.access$write(resp, response.getStatus(), response.getHeaders(), response.getBody());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object requestBody(Map<String, String> headers, HttpServletRequest req) {
        Serializable serializable;
        String string = headers.get("Content-Type");
        if (string == null) {
            return LocalServerKt.access$bodyAsString(req);
        }
        String contentType = string;
        Object object = ContentType.Companion.parse(contentType);
        String mimeType = object.component1();
        Set<String> set = this.binaryMimeTypes;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binaryMimeTypes");
        }
        if (set.contains(mimeType)) {
            byte[] byArray;
            object = (Closeable)req.getInputStream();
            boolean bl = false;
            Throwable throwable = null;
            try {
                ServletInputStream it = (ServletInputStream)object;
                boolean bl2 = false;
                ServletInputStream servletInputStream = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)servletInputStream, (String)"it");
                byArray = ByteStreamsKt.readBytes((InputStream)((InputStream)servletInputStream));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            serializable = (Serializable)byArray;
        } else {
            serializable = (Serializable)((Object)LocalServerKt.access$bodyAsString(req));
        }
        return serializable;
    }

    private final String initParam(@NotNull ServletConfig $this$initParam, String name) {
        String string = $this$initParam.getInitParameter(name);
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("Missing init param " + name);
        }
        return string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lws/osiris/localserver/OsirisServlet$Companion;", "", "()V", "API_ATTRIBUTE", "", "COMPONENTS_ATTRIBUTE", "REQUEST_CONTEXT_FACTORY_ATTRIBUTE", "osiris-local-server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

