/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.core;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u001f\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lws/osiris/core/ContentType;", "", "mimeType", "", "(Ljava/lang/String;)V", "charset", "Ljava/nio/charset/Charset;", "(Ljava/lang/String;Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "header", "getHeader", "()Ljava/lang/String;", "getMimeType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "osiris-core"})
public final class ContentType {
    @NotNull
    private final String header;
    @NotNull
    private final String mimeType;
    @Nullable
    private final Charset charset;
    private static final Regex REGEX;
    public static final Companion Companion;

    @NotNull
    public final String getHeader() {
        return this.header;
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    @Nullable
    public final Charset getCharset() {
        return this.charset;
    }

    public ContentType(@NotNull String mimeType, @Nullable Charset charset) {
        String string;
        ContentType contentType;
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        this.mimeType = mimeType;
        this.charset = charset;
        if (StringsKt.isBlank((CharSequence)this.mimeType)) {
            throw (Throwable)new IllegalArgumentException("MIME type cannot be blank");
        }
        ContentType contentType2 = this;
        if (this.charset == null) {
            String string2 = this.mimeType;
            ContentType contentType3 = contentType2;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            contentType = contentType3;
            string = string4;
        } else {
            String string5 = this.mimeType;
            StringBuilder stringBuilder = new StringBuilder();
            ContentType contentType4 = contentType2;
            boolean bl = false;
            String string6 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string7 = ((Object)StringsKt.trim((CharSequence)string6)).toString();
            contentType = contentType4;
            string = stringBuilder.append(string7).append("; charset=").append(this.charset.name()).toString();
        }
        contentType.header = string;
    }

    public ContentType(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        this(mimeType, null);
    }

    static {
        Companion = new Companion(null);
        REGEX = new Regex("\\s*(\\S+?)\\s*(;.*charset=(\\S+).*)?", RegexOption.IGNORE_CASE);
    }

    @NotNull
    public final String component1() {
        return this.mimeType;
    }

    @Nullable
    public final Charset component2() {
        return this.charset;
    }

    @NotNull
    public final ContentType copy(@NotNull String mimeType, @Nullable Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        return new ContentType(mimeType, charset);
    }

    public static /* synthetic */ ContentType copy$default(ContentType contentType, String string, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            string = contentType.mimeType;
        }
        if ((n & 2) != 0) {
            charset = contentType.charset;
        }
        return contentType.copy(string, charset);
    }

    @NotNull
    public String toString() {
        return "ContentType(mimeType=" + this.mimeType + ", charset=" + this.charset + ")";
    }

    public int hashCode() {
        String string = this.mimeType;
        Charset charset = this.charset;
        return (string != null ? string.hashCode() : 0) * 31 + (charset != null ? ((Object)charset).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ContentType)) break block3;
                ContentType contentType = (ContentType)object;
                if (!Intrinsics.areEqual((Object)this.mimeType, (Object)contentType.mimeType) || !Intrinsics.areEqual((Object)this.charset, (Object)contentType.charset)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lws/osiris/core/ContentType$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "parse", "Lws/osiris/core/ContentType;", "header", "", "osiris-core"})
    public static final class Companion {
        @NotNull
        public final ContentType parse(@NotNull String header) {
            Charset charset;
            Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
            MatchResult matchResult = REGEX.matchEntire((CharSequence)header);
            if (matchResult == null) {
                throw (Throwable)new IllegalArgumentException("Invalid Content-Type");
            }
            MatchResult matchResult2 = matchResult;
            MatchGroup matchGroup = matchResult2.getGroups().get(1);
            String string = matchGroup != null ? matchGroup.getValue() : null;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String mimeType = string;
            MatchGroup matchGroup2 = matchResult2.getGroups().get(3);
            if (matchGroup2 != null) {
                MatchGroup matchGroup3 = matchGroup2;
                boolean bl = false;
                boolean bl2 = false;
                MatchGroup it = matchGroup3;
                boolean bl3 = false;
                charset = Charset.forName(it.getValue());
            } else {
                charset = null;
            }
            Charset charset2 = charset;
            return new ContentType(mimeType, charset2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

