/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.core;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.osiris.core.ComponentsProvider;
import ws.osiris.core.ContentType;
import ws.osiris.core.ErrorInfo;
import ws.osiris.core.ExceptionHandler;
import ws.osiris.core.Filter;
import ws.osiris.core.FiltersKt;
import ws.osiris.core.HttpException;
import ws.osiris.core.HttpKt;
import ws.osiris.core.Request;
import ws.osiris.core.Response;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u001a\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u0007\u001a\\\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072D\u0010\f\u001a@\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000e\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011\u0012\u0004\u0012\u00020\u00120\rj\b\u0012\u0004\u0012\u0002H\u0006`\u0013\u00a2\u0006\u0002\b\u0011\u001a5\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0015\"\u000e\b\u0000\u0010\u0006\u0018\u0001*\u00060\u0016j\u0002`\u00172\u0014\b\b\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0086\b\u001a(\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u001d\u001a\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u0007\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001f"}, d2={"log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "defaultContentTypeFilter", "Lws/osiris/core/Filter;", "T", "Lws/osiris/core/ComponentsProvider;", "contentType", "Lws/osiris/core/ContentType;", "defaultExceptionMappingFilter", "defineFilter", "handler", "Lkotlin/Function3;", "Lws/osiris/core/Request;", "Lkotlin/Function2;", "Lws/osiris/core/Response;", "Lkotlin/ExtensionFunctionType;", "", "Lws/osiris/core/FilterHandler;", "exceptionHandler", "Lws/osiris/core/ExceptionHandler;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handlerFn", "Lkotlin/Function1;", "Lws/osiris/core/ErrorInfo;", "exceptionMappingFilter", "exceptionHandlers", "", "jsonSerialisingFilter", "osiris-core"})
public final class FiltersKt {
    @NotNull
    private static final Logger log;

    @NotNull
    public static final Logger getLog() {
        return log;
    }

    @NotNull
    public static final <T extends ComponentsProvider> Filter<T> defineFilter(@NotNull Function3<? super T, ? super Request, ? super Function2<? super T, ? super Request, Response>, ? extends Object> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        return new Filter<T>("/*", handler);
    }

    @NotNull
    public static final <T extends ComponentsProvider> Filter<T> defaultContentTypeFilter(@NotNull ContentType contentType) {
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        return FiltersKt.defineFilter((Function3)new Function3<T, Request, Function2<? super T, ? super Request, ? extends Response>, Response>(contentType){
            final /* synthetic */ ContentType $contentType;

            @NotNull
            public final Response invoke(@NotNull T $receiver, @NotNull Request req, @NotNull Function2<? super T, ? super Request, Response> handler) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
                Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
                Map defaultHeaders = MapsKt.plus(req.getDefaultResponseHeaders$osiris_core(), (Pair)TuplesKt.to((Object)"Content-Type", (Object)this.$contentType.getHeader()));
                Request updatedReq = Request.copy$default(req, null, null, null, null, null, null, null, null, defaultHeaders, 255, null);
                return (Response)handler.invoke($receiver, (Object)updatedReq);
            }
            {
                this.$contentType = contentType;
                super(3);
            }
        });
    }

    @NotNull
    public static final <T extends ComponentsProvider> Filter<T> jsonSerialisingFilter() {
        Gson gson = new Gson();
        return FiltersKt.defineFilter((Function3)new Function3<T, Request, Function2<? super T, ? super Request, ? extends Response>, Response>(gson){
            final /* synthetic */ Gson $gson;

            @NotNull
            public final Response invoke(@NotNull T $receiver, @NotNull Request req, @NotNull Function2<? super T, ? super Request, Response> handler) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
                Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
                Response response = (Response)handler.invoke($receiver, (Object)req);
                String contentTypeHeader = response.getHeaders().get("Content-Type");
                ContentType contentType = contentTypeHeader == null || Intrinsics.areEqual((Object)contentTypeHeader, (Object)HttpKt.getJSON_CONTENT_TYPE().getHeader()) ? HttpKt.getJSON_CONTENT_TYPE() : ContentType.Companion.parse(contentTypeHeader);
                return Intrinsics.areEqual((Object)contentType.getMimeType(), (Object)"application/json") && response.getBody() != null && !(response.getBody() instanceof String) ? Response.copy$default(response, 0, null, this.$gson.toJson(response.getBody()), 3, null) : response;
            }
            {
                this.$gson = gson;
                super(3);
            }
        });
    }

    @NotNull
    public static final <T extends ComponentsProvider> Filter<T> exceptionMappingFilter(@NotNull List<? extends ExceptionHandler<?>> exceptionHandlers) {
        Intrinsics.checkParameterIsNotNull(exceptionHandlers, (String)"exceptionHandlers");
        return FiltersKt.defineFilter((Function3)new Function3<T, Request, Function2<? super T, ? super Request, ? extends Response>, Response>(exceptionHandlers){
            final /* synthetic */ List $exceptionHandlers;

            @NotNull
            public final Response invoke(@NotNull T $receiver, @NotNull Request req, @NotNull Function2<? super T, ? super Request, Response> handler) {
                Response response;
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
                Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
                try {
                    response = (Response)handler.invoke($receiver, (Object)req);
                }
                catch (Exception e) {
                    Response response2;
                    ErrorInfo info2 = (ErrorInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.$exceptionHandlers), (Function1)((Function1)new Function1<ExceptionHandler<?>, ErrorInfo>(e){
                        final /* synthetic */ Exception $e;

                        @Nullable
                        public final ErrorInfo invoke(@NotNull ExceptionHandler<?> it) {
                            Intrinsics.checkParameterIsNotNull(it, (String)"it");
                            return it.handle(this.$e);
                        }
                        {
                            this.$e = exception;
                            super(1);
                        }
                    }))));
                    if (info2 != null) {
                        response2 = Response.Companion.error$osiris_core(info2.getStatus(), info2.getMessage());
                    } else {
                        FiltersKt.getLog().error("Server Error", (Throwable)e);
                        response2 = Response.Companion.error$osiris_core(500, "Server Error");
                    }
                    response = response2;
                }
                return response;
            }
            {
                this.$exceptionHandlers = list;
                super(3);
            }
        });
    }

    private static final <T extends Exception> ExceptionHandler<T> exceptionHandler(Function1<? super T, ErrorInfo> handlerFn) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return new ExceptionHandler<T>(Reflection.getOrCreateKotlinClass(Exception.class), handlerFn);
    }

    @NotNull
    public static final <T extends ComponentsProvider> Filter<T> defaultExceptionMappingFilter() {
        Function1 handlerFn$iv;
        ExceptionHandler exceptionHandler;
        Object[] objectArray;
        Function1 function1 = defaultExceptionMappingFilter.handlers.1.INSTANCE;
        int n = 0;
        Object[] objectArray2 = objectArray = new ExceptionHandler[2];
        objectArray[n] = exceptionHandler = new ExceptionHandler(Reflection.getOrCreateKotlinClass(HttpException.class), handlerFn$iv);
        handlerFn$iv = defaultExceptionMappingFilter.handlers.2.INSTANCE;
        n = 1;
        objectArray = objectArray2;
        objectArray[n] = exceptionHandler = new ExceptionHandler(Reflection.getOrCreateKotlinClass(IllegalArgumentException.class), handlerFn$iv);
        List handlers2 = CollectionsKt.listOf((Object[])objectArray2);
        return FiltersKt.exceptionMappingFilter(handlers2);
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"ws.osiris.core");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\"ws.osiris.core\")");
        log = logger;
    }
}

