/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import ws.osiris.aws.LambdaKt;
import ws.osiris.aws.ProxyResponse;
import ws.osiris.core.Api;
import ws.osiris.core.ComponentsProvider;
import ws.osiris.core.DataNotFoundException;
import ws.osiris.core.HttpMethod;
import ws.osiris.core.LambdaRoute;
import ws.osiris.core.Request;
import ws.osiris.core.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B\u001b\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002R\u0010\u0010\b\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RG\u0010\u000e\u001a;\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0012%\u0012#\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\b\u0012\u0004\u0012\u00028\u0000`\u0016\u00a2\u0006\u0002\b\u00170\u000fX\u0088\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lws/osiris/aws/ProxyLambda;", "T", "Lws/osiris/core/ComponentsProvider;", "Lcom/amazonaws/services/lambda/runtime/RequestHandler;", "Lcom/amazonaws/services/lambda/runtime/events/APIGatewayProxyRequestEvent;", "Lws/osiris/aws/ProxyResponse;", "api", "Lws/osiris/core/Api;", "components", "(Lws/osiris/core/Api;Lws/osiris/core/ComponentsProvider;)V", "Lws/osiris/core/ComponentsProvider;", "id", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "routeMap", "", "Lkotlin/Pair;", "Lws/osiris/core/HttpMethod;", "", "Lkotlin/Function2;", "Lws/osiris/core/Request;", "Lws/osiris/core/Response;", "Lws/osiris/core/RequestHandler;", "Lkotlin/ExtensionFunctionType;", "encodeBinaryBody", "byteArray", "", "handleRequest", "requestEvent", "context", "Lcom/amazonaws/services/lambda/runtime/Context;", "keepAlive", "", "osiris-aws"})
public abstract class ProxyLambda<T extends ComponentsProvider>
implements RequestHandler<APIGatewayProxyRequestEvent, ProxyResponse> {
    private final Map<Pair<HttpMethod, String>, Function2<T, Request, Response>> routeMap;
    private final UUID id;
    private final T components;

    @NotNull
    public ProxyResponse handleRequest(@NotNull APIGatewayProxyRequestEvent requestEvent, @NotNull Context context) {
        ProxyResponse proxyResponse;
        Intrinsics.checkParameterIsNotNull((Object)requestEvent, (String)"requestEvent");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        LambdaKt.access$getLog$p().debug("Function {} handling requestEvent {}", (Object)this.id, (Object)requestEvent);
        if (this.keepAlive(requestEvent)) {
            return new ProxyResponse(0, null, false, null, 15, null);
        }
        Request request = LambdaKt.buildRequest(requestEvent, context);
        LambdaKt.access$getLog$p().debug("Request endpoint: {} {}", (Object)request.getMethod(), (Object)request.getPath());
        Function2<T, Request, Response> function2 = this.routeMap.get(new Pair((Object)request.getMethod(), (Object)request.getPath()));
        if (function2 == null) {
            throw (Throwable)new DataNotFoundException(null, 1, null);
        }
        Function2<T, Request, Response> handler = function2;
        LambdaKt.access$getLog$p().debug("Invoking handler");
        Response response = (Response)handler.invoke(this.components, (Object)request);
        LambdaKt.access$getLog$p().debug("Invoked handler");
        Object body = response.getBody();
        if (body == null) {
            proxyResponse = new ProxyResponse(response.getStatus(), response.getHeaders().getHeaderMap(), false, null);
        } else if (body instanceof byte[]) {
            proxyResponse = new ProxyResponse(response.getStatus(), response.getHeaders().getHeaderMap(), true, this.encodeBinaryBody((byte[])body));
        } else if (body instanceof String) {
            proxyResponse = new ProxyResponse(response.getStatus(), response.getHeaders().getHeaderMap(), false, (String)body);
        } else {
            throw (Throwable)new IllegalStateException("Response must contain null, a string or a ByteArray");
        }
        ProxyResponse proxyResponse2 = proxyResponse;
        LambdaKt.access$getLog$p().debug("Returning response: {}", (Object)proxyResponse2);
        return proxyResponse2;
    }

    private final String encodeBinaryBody(byte[] byteArray) {
        byte[] byArray = Base64.getEncoder().encode(byteArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getEncoder().encode(byteArray)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        return new String(byArray2, charset);
    }

    private final boolean keepAlive(APIGatewayProxyRequestEvent requestEvent) {
        int n;
        if (Intrinsics.areEqual((Object)requestEvent.getResource(), (Object)"[keepAlive]") ^ true) {
            return false;
        }
        String string = (String)requestEvent.getHeaders().get("sleepTimeMs");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = 200;
        }
        int sleepTimeMs = n;
        LambdaKt.access$getLog$p().debug("Keep-alive request received. Sleeping for {}ms. Function {}", (Object)sleepTimeMs, (Object)this.id);
        Thread.sleep(sleepTimeMs);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public ProxyLambda(@NotNull Api<T> api, @NotNull T components) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkParameterIsNotNull(api, (String)"api");
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        this.components = components;
        this.id = UUID.randomUUID();
        LambdaKt.access$getLog$p().debug("Creating ProxyLambda");
        Iterable iterable = api.getRoutes();
        ProxyLambda proxyLambda = this;
        boolean $i$f$filterIsInstance = false;
        void var5_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LambdaRoute)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        $this$filterIsInstance$iv = (Iterable)object;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            LambdaRoute it;
            LambdaRoute lambdaRoute = (LambdaRoute)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Pair pair = new Pair((Object)it.getMethod(), (Object)it.getPath());
            it = (LambdaRoute)element$iv$iv;
            boolean bl2 = false;
            Function2 function2 = it.getHandler();
            object.put(pair, function2);
        }
        proxyLambda.routeMap = object = destination$iv$iv2;
        LambdaKt.access$getLog$p().debug("Created routes: {}", this.routeMap.keySet());
    }
}

