/*
 * Decompiled with CFR 0.152.
 */
package ws.osiris.aws;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import com.amazonaws.services.lambda.model.InvocationType;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.google.gson.Gson;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.osiris.aws.KeepAliveLambda;
import ws.osiris.aws.KeepAliveTrigger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lws/osiris/aws/KeepAliveLambda;", "", "()V", "gson", "Lcom/google/gson/Gson;", "lambdaClient", "Lcom/amazonaws/services/lambda/AWSLambda;", "handle", "", "trigger", "Lws/osiris/aws/KeepAliveTrigger;", "Companion", "osiris-aws"})
public final class KeepAliveLambda {
    private final AWSLambda lambdaClient;
    private final Gson gson;
    private static final Logger log;
    public static final Companion Companion;

    public final void handle(@NotNull KeepAliveTrigger trigger) {
        String json;
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        log.debug("Triggering keep-alive, count: {}, function: {}", (Object)trigger.getInstanceCount(), (Object)trigger.getFunctionArn());
        APIGatewayProxyRequestEvent aPIGatewayProxyRequestEvent = new APIGatewayProxyRequestEvent();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$apply = aPIGatewayProxyRequestEvent;
        boolean bl3 = false;
        $this$apply.setResource("[keepAlive]");
        $this$apply.setHeaders(MapsKt.mapOf((Pair)TuplesKt.to((Object)"sleepTimeMs", (Object)String.valueOf(trigger.getSleepTimeMs()))));
        APIGatewayProxyRequestEvent requestEvent = aPIGatewayProxyRequestEvent;
        String string = json = this.gson.toJson((Object)requestEvent);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json");
        String string2 = string;
        $this$apply = Charsets.UTF_8;
        boolean bl4 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes((Charset)$this$apply);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        ByteBuffer payloadBuffer = ByteBuffer.wrap(byArray);
        $this$apply = new InvokeRequest();
        bl4 = false;
        boolean bl5 = false;
        Object $this$apply2 = $this$apply;
        boolean bl6 = false;
        $this$apply2.setFunctionName(trigger.getFunctionArn());
        $this$apply2.setInvocationType(InvocationType.Event.name());
        $this$apply2.setPayload(payloadBuffer);
        Object invokeRequest = $this$apply;
        Function1<Integer, Unit> $fun$invokeFunctions$1 = new Function1<Integer, Unit>(this, trigger, (InvokeRequest)invokeRequest){
            final /* synthetic */ KeepAliveLambda this$0;
            final /* synthetic */ KeepAliveTrigger $trigger;
            final /* synthetic */ InvokeRequest $invokeRequest;

            public final void invoke(int attemptCount) {
                while (true) {
                    try {
                        int n = this.$trigger.getInstanceCount();
                        boolean bl = false;
                        int n2 = 0;
                        n2 = 0;
                        int n3 = n;
                        while (n2 < n3) {
                            int it = n2++;
                            boolean bl2 = false;
                            KeepAliveLambda.access$getLambdaClient$p(this.this$0).invoke(this.$invokeRequest);
                        }
                        KeepAliveLambda.access$getLog$cp().debug("Keep-alive complete");
                        return;
                    }
                    catch (Exception e) {
                        if (attemptCount == 7) {
                            throw (Throwable)e;
                        }
                        double d = 2.0;
                        long l = 1000L;
                        boolean bl = false;
                        double d2 = Math.pow(d, attemptCount);
                        long sleep = l * (long)d2;
                        KeepAliveLambda.access$getLog$cp().debug("Exception triggering keep-alive: {} {}, sleeping for {}ms", new Object[]{e.getClass().getName(), e.getMessage(), sleep});
                        Thread.sleep(sleep);
                        ++attemptCount;
                        continue;
                    }
                    break;
                }
            }

            public static /* synthetic */ void invoke$default(handle.1 var0, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = 1;
                }
                var0.invoke(n);
            }
            {
                this.this$0 = keepAliveLambda;
                this.$trigger = keepAliveTrigger;
                this.$invokeRequest = invokeRequest;
                super(1);
            }
        };
        handle.1.invoke$default($fun$invokeFunctions$1, 0, 1, null);
    }

    public KeepAliveLambda() {
        AWSLambda aWSLambda = AWSLambdaClientBuilder.defaultClient();
        Intrinsics.checkExpressionValueIsNotNull((Object)aWSLambda, (String)"AWSLambdaClientBuilder.defaultClient()");
        this.lambdaClient = aWSLambda;
        this.gson = new Gson();
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(KeepAliveLambda.class);
    }

    public static final /* synthetic */ AWSLambda access$getLambdaClient$p(KeepAliveLambda $this) {
        return $this.lambdaClient;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lws/osiris/aws/KeepAliveLambda$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "osiris-aws"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

